<?php
$pageTitle = ""; //Please add page title here
$metaDesc = ""; //Please add meta description here
$metaKey = ""; //Please add meta keywords here
include 'includes/header.php';?>
<section id="main-banner" class="inner-banner">
    <img src="<?php echo BASE_URL;?>images/range-img/banner.jpg" alt="banner img" class="img-fluid"/>
    <h1>Ranges</h1>
</section>
<section class="inner-content padd-sec">
    <div class="container">
    <h2>Explore our diverse garden room ranges</h2>
        <p>At Elevate Garden Rooms, we appreciate that every garden and homeowner is unique. That's why we offer a vast range of garden room options tailored to fit any style or space requirement you may have. Whether you are looking for a compact retreat to maximise a small garden area or an expansive design to fill a larger plot, we have a solution to meet your needs.</p>
        <p>Our versatile range ensures that no matter the vision you have for your outdoor area, we can craft a garden room that harmonises seamlessly with your setting, catering to specific aesthetic desires and space constraints.</p>
        <hr/>
        <h2>Ranges by size</h2>
        <div class="range-blk" id="range2">    
            <div class="half-sec row">
                <div class="col-md-7">
                    <div class="text-blk">
                        <h3>2.5x2.5 – prices start from £13,500+VAT
                        </h3>
                            <h4>What's included:</h4>
                            <p><b>Ground screw foundation</b></p>
                            <p><b>Electrics:</b> 4 spot lights, 3 soffit spots, 2 up and down lights, 2 sockets, 1 Wi-Fi point, 1 fuse board, 20m armoured run to property including connection.</p>
                            <p><b>Door:</b> French door</p>
                            <p><b>Flooring:</b> Laminate up to £20m2</p>
                            <p><b>Additional materials and components:</b></p>
                            <ul class="arw-ul d-flex">
                                <li>4x2 @2.4 - 17 </li>
                                <li>100mm Celotex - 3</li>
                                <li>22mm floor - 6</li>
                                <li>4x2@ 2.4 - 30</li>
                                <li>4x2@2.4 - 0</li>
                                <li>4x2@2.4 - 0</li>
                                <li>Battens - 2</li>
                                <li>5x2@3.6 - 13</li>
                                <li>18mm OSB - 7</li>
                                <li>11mm - 9</li>
                                <li>Floor glue - 1</li>
                                <li>Breathable membrane - 1</li>
                                <li>Clear membrane - 1</li>
                                <li>Plaster boards - 12</li>
                            </ul>
                    </div>
                </div>
                <div class="col-md-5 img-blk">
                    <img src="<?php echo BASE_URL;?>images/range-img/range1.png" alt="" class="img-fluid">
                </div>
            </div>
        </div>
        <!--  -->
        <div class="range-blk" id="range3">    
            <div class="half-sec row flex-lg-row-reverse">
                <div class="col-md-7">
                    <div class="text-blk">
                        <h3>3x3 – prices start from £14,300+VAT
                        </h3>
                        <h4>What's included:</h4>
                        <p><b>Ground screw foundation</b></p>
                        <p><b>Electrics:</b> 4 spot lights, 3 soffit spots, 2 up and down lights, 2 sockets, 1 Wi-Fi point, 1 fuse board, 20m armoured run to property including connection.</p>
                        <p><b>Door:</b> French door</p>
                        <p><b>Flooring:</b> Laminate up to £20m2</p>
                        <p><b>Additional materials and components:</b></p>

                        <ul class="arw-ul d-flex">
                            <li>4x2 @3– 9</li>
                            <li>4x2 @3m – 18</li>
                            <li>100mm Celotex – 5</li>
                            <li>22mm floor – 8</li>
                            <li>4x2@ 2.4 – 35</li>
                            <li>4x2@2.4 – 0</li>
                            <li>4x2@2.4 – 0</li>
                            <li>Battens – 2</li>
                            <li>5x2@3.6 – 15</li>
                            <li>18mm OSB – 9</li>
                            <li>11mm – 10</li>
                            <li>Floor glue – 1</li>
                            <li>Breathable membrane – 1</li>
                            <li>Clear membrane – 1</li>
                            <li>Plaster boards - 14</li>
                        </ul>
                    </div>
                </div>
                <div class="col-md-5 img-blk">
                    <img src="<?php echo BASE_URL;?>images/range-img/range1.png" alt="" class="img-fluid">
                </div>
            </div>
        </div>
        <!--  -->
        <div class="range-blk" id="range4">
            <div class="half-sec row">
                <div class="col-md-7">
                    <div class="text-blk">
                        <h3>4x3 – prices start from £15,800+VA
                        </h3>
                            <h4>What's included:</h4>
                            <p><b>Ground screw foundation</b></p>
                            <p><b>Electrics:</b> 6 spot lights, 4 soffit spots, 2 up and down lights, 4 sockets, 1 Wi-Fi point, 1 fuse board, 20m armoured run to property including connection.</p>
                            <p><b>Door:</b> French door</p>
                            <p><b>Flooring:</b> Laminate up to £20m2</p>
                            <p><b>Additional materials and components:</b></p>
                            <ul class="arw-ul d-flex">
                                <li>4x2 @3 m - 14</li>
                                <li>4x2@4.8 – 6</li>
                                <li>100mm Celotex – 6</li>
                                <li>22mm floor – 10</li>
                                <li>4x2@ 2.4 – 40</li>
                                <li>4x2@2.4 – 0</li>
                                <li>4x2@2.4 – 0</li>
                                <li>Battens – 3</li>
                                <li>5x2@3.6 – 18</li>
                                <li>18mm OSB – 12</li>
                                <li>11mm – 12</li>
                                <li>Floor glue – 1</li>
                                <li>Breathable membrane – 1</li>
                                <li>Clear membrane – 1</li>
                                <li>Plaster boards - 16</li>
                            </ul>
                    </div>
                </div>
                <div class="col-md-5 img-blk">
                    <img src="<?php echo BASE_URL;?>images/range-img/range1.png" alt="" class="img-fluid">
                </div>
            </div>
        </div>
        <!--  -->
        <div class="range-blk" id="range5">  
            <div class="half-sec row flex-lg-row-reverse">
                <div class="col-md-7">
                    <div class="text-blk">
                        <h3>5x3 – prices start from £17,900+VAT
                        </h3>
                        <h4>What's included:</h4>
                        <p><b>Ground screw foundation</b></p>
                        <p><b>Electrics:</b> 6 spot lights, 4 soffit spots, 2 up and down lights, 4 sockets, 1 Wi-Fi point, 1 fuse board, 20m armoured run to property including connection.</p>
                        <p><b>Door:</b> French door</p>
                        <p><b>Window:</b> Floor to ceiling window</p>
                        <p><b>Flooring:</b> Laminate up to £20m2</p>
                        <p><b>Additional materials and components</b></p>
                        <ul class="arw-ul d-flex">
                            <li>4x2 @3 – 21</li>
                            <li>4x2@4.8 – 10</li>
                            <li>100mm Celotex – 7</li>
                            <li>22mm floor – 12</li>
                            <li>4x2@ 2.4 – 45</li>
                            <li>4x2@2.4 – 0</li>
                            <li>4x2@2.4 – 0</li>
                            <li>Battens – 2</li>
                            <li>5x2@3.6 – 20</li>
                            <li>18mm OSB – 14</li>
                            <li>11mm – 14</li>
                            <li>Floor glue – 1</li>
                            <li>Breathable membrane – 1</li>
                            <li>Clear membrane – 1</li>
                            <li>Plaster boards – 20</li>
                        </ul>
                    </div>
                </div>
                <div class="col-md-5 img-blk">
                    <img src="<?php echo BASE_URL;?>images/range-img/range1.png" alt="" class="img-fluid">
                </div>
            </div>
        </div>
        <!--  -->
        <div class="range-blk" id="range6">   
            <div class="half-sec row">
                <div class="col-md-7">
                    <div class="text-blk">
                        <h3>6x3  - prices start from £20,200+VAT
                        </h3>
                            <h4>What's included:</h4>
                            <p><b>Ground screw foundation</b></p>
                            <p><b>Electrics:</b> 8 spot lights, 4 soffit spots, 2 up and down lights, 4 sockets, 1 Wi-Fi point, 1 fuse board, 20m armoured run to property plus connection</p>
                            <p><b>Door:</b> French door</p>
                            <p><b>Window:</b> 2x floor to ceiling</p>
                            <p><b>Flooring:</b> Laminate up to £20m2</p>
                            <p><b>Additional materials and components</b></p>
                            <ul class="arw-ul d-flex">
                                <li>4x2 @3 – 24</li>
                                <li>4x2@4x8 - 12</li>
                                <li>100mm Celotex – 8</li>
                                <li>22mm floor – 13</li>
                                <li>4x2@ 2.4 – 50</li>
                                <li>4x2@2.4 – 0</li>
                                <li>4x2@2.4 – 0</li>
                                <li>Battens – 3</li>
                                <li>5x2@3.6 – 21</li>
                                <li>18mm OSB – 16</li>
                                <li>11mm – 15</li>
                                <li>Floor glue – 1</li>
                                <li>Breathable membrane – 1</li>
                                <li>Clear membrane – 1</li>
                                <li>Plaster boards – 22</li>
                            </ul>
                    </div>
                </div>
                <div class="col-md-5 img-blk">
                    <img src="<?php echo BASE_URL;?>images/range-img/range1.png" alt="" class="img-fluid">
                </div>
            </div>
        </div>
        <!--  -->
        <div class="range-blk" id="range7">    
            <div class="half-sec row flex-lg-row-reverse">
                <div class="col-md-7">
                    <div class="text-blk">
                        <h3>7x3 – prices start from £22,450+VAT
                        </h3>
                        <h4>What's included:</h4>
                        <p><b>Ground screw foundation</b></p>
                        <p><b>Electrics:</b> 8 spot lights, 5 soffit spots, 2 up and down lights, 4 sockets, 1 Wi-Fi point, 1 fuse board, 20m armoured run to property plus connection</p>
                        <p><b>Door:</b> French door</p>
                        <p><b>Window:</b> 2x floor to ceiling</p>
                        <p><b>Flooring:</b> Laminate up to £20m2</p>
                        <p><b>Additional materials and components:</b></p>
                        <ul class="arw-ul d-flex">
                            <li>4x2 @3 – 26</li>
                            <li>4x2@4x8 - 14</li>
                            <li>100mm Celotex – 9</li>
                            <li>22mm floor – 16</li>
                            <li>4x2@ 2.4 – 55</li>
                            <li>4x2@2.4 – 0</li>
                            <li>4x2@2.4 – 0</li>
                            <li>Battens – 3</li>
                            <li>5x2@3.6 – 24</li>
                            <li>18mm OSB – 20</li>
                            <li>11mm – 17</li>
                            <li>Floor glue – 1</li>
                            <li>Breathable membrane – 1</li>
                            <li>Clear membrane – 1</li>
                            <li>Plaster boards – 25</li>
                        </ul>
                    </div>
                </div>
                <div class="col-md-5 img-blk">
                    <img src="<?php echo BASE_URL;?>images/range-img/range1.png" alt="" class="img-fluid">
                </div>
            </div>
        </div>
        <!--  -->
    </div>
</section>

<section class="smooth-sec padd-sec ranges-main">
    <div class="container">
        
    <h2>Ranges by style</h2>
        <div class="row">
            <div class="col-lg-6">
    <h3>Elevate Classic Collection</h3>
    <p>The Elevate Classic Collection embodies timeless elegance and robust construction, making it an ideal choice for those seeking sophistication alongside functionality. This range blends traditional aesthetics with modern innovation, ensuring each garden room is not only beautiful but also built to last.</p>
<p>With an emphasis on quality materials and superior craftsmanship, the Classic Collection offers versatile spaces that can transform into offices, studios, or tranquil retreats according to your needs. Complement any garden setting with the collection's subtle design elements that enhance the natural surroundings while providing exceptional comfort and utility.</p>

<p><b>Choose from 3 charming styles:</b></p>
<ul class="smooth-list">
            <li>
            <p><b>
                Elevate classic collection 01:
            </b> Full composite smooth grain finish</p>
            </li>
            <li>
                <p>
                <b>Elevate classic collection 02:</b> Full composite wood grain effect

                </p>
            </li>
            <li>
                <p>
                <b>Elevate classic collection 03:</b> Full composite slated composite 


                </p>
            </li>
        </ul>
            </div>
            <div class="col-lg-6">
            <h3>Elevate Cedar Retreats Collection</h3>
<p>The Elevate Cedar Retreats Collection offers a harmonious blend of nature and design, perfect for those who appreciate the organic beauty of natural wood. Crafted with sustainably sourced cedar, this collection emphasises eco-friendly practices without compromising on style or durability. Each garden room within the Cedar Retreats Collection showcases the rich textures and warm colours of cedar, providing a serene and inviting space.</p>
<p>Ideal for use as a home office, art studio, or relaxation sanctuary, these garden rooms bring a touch of the outdoors inside, creating a peaceful retreat that complements both urban and rural landscapes.</p>
<p><b>Cedar retreats come in 2 options:</b></p>
<ul class="smooth-list">
    <li>
        <p><b>Elevate Cedar Retreats 01:</b> Full cedar </p>
    </li>
    <li>
        <p><b>Elevate Cedar Retreats 02:</b> Cedar front with composite back and sides </p>
    </li>
</ul>

            </div>
        </div>
    </div>

</section>
<section class="dream-sec padd-sec">
    <div class="container">
    <p><b class="orange-txt">Ranges by style</b></p>
    <h2>Fully bespoke garden rooms</h2>
<p>Discover the pinnacle of personalization with our fully bespoke garden room service, where every element is crafted precisely to match your unique vision. This service is characterised by a commitment to meticulous design and unmatched craftsmanship, ensuring that each garden room is as distinctive as its owner.</p>
<p>From the initial consultation, our team collaborates closely with clients to understand their specific requirements and aspirations, transforming ideas into reality. Whether it’s a bespoke layout, custom finishes, or unique functionalities, we harness the highest quality materials and cutting-edge techniques to bring your dream space to life.</p>
<p>Experience the freedom of design without limitations, as our bespoke service tailors each feature to fit seamlessly into your lifestyle and harmonise with your environment.</p>

<div class="btn-blk">
            <?php echo $contact ?>
            <?php echo $call ?>
        </div>
    </div>
</section>


<section class="smooth-sec padd-sec ranges-main" style="background-image:url(images/range-img/smoothbg1.jpg)">
    <div class="container">
        <p><b class="orange-txt">Ranges by style</b></p>
    <h2>Elevate Canopy Hideaways (add-on with other ranges)</h2>
    <p>The Elevate Canopy Hideaways offer a unique enhancement to your existing garden room, creating a seamless extension that blends outdoor and indoor living. This versatile add-on option allows you to enjoy the beauty of your garden with the added comfort of a sheltered space.</p>
<p>Perfect for outdoor dining, relaxation, or entertainment, the canopy hideaway is designed to complement any style within the Elevate range, adding both functional space and aesthetic appeal. Opt for a customised canopy to suit your needs and elevate your garden experience year-round with this stylish and practical addition.</p>
<p><b>3 choices to choose from:</b></p>
<ul class="smooth-list d-flex">
    <li><b>Elevate canopy hideaway 01: </b> back and side wall</li>
    <li><b>Elevate canopy hideaway 02: </b> back wall & post</li>
    <li><b>Elevate canopy hideaway 03: </b> double post</li>
</ul>

            
    </div>

</section>

<section class="dream-sec padd-sec range-main">
    <div class="container">
    <p><b class="orange-txt">Ranges by style</b></p>
    <h2>Elevate Garden Getaway (wallet friendly)</h2>
    <p>The Elevate Garden Getaway range is the perfect solution for those seeking an affordable yet stylish garden room without compromising on quality. Ideal for budget-conscious buyers, this collection offers a range of multifunctional spaces tailored to fit a variety of needs—from home offices to leisure retreats.</p>
<p>Each design in the Garden Getaway range maximises space efficiency while incorporating essential features that ensure comfort and usability. With a focus on practicality and affordability, these garden rooms blend seamlessly into any outdoor setting, providing a versatile and inviting extension to your home.</p>
<p><b>Enhance your home for less with our 2 Garden Getaway offerings:</b></p>

<ul class="smooth-list">
    <li><p><b class="orange-txt">Elevate budget friendly room 01:</b>  Cedar with metal sheeting</p></li>
    <li><p><b class="orange-txt">Elevate budget friendly room 02:</b> composite with metal sheeting</p></li>
</ul>
<div class="text-uppercase orange-txt h6">
<p>Learn more about the metal cladding and profiles we provide (data sheet to be provided by client)</p>
<p>Photos of rooms (to be provided by client)</p>

</div>

    </div>
</section>

<section class="services-sec padd-sec">
    <div class="container">
        <h2>We make it, you make it yours</h2>  
        <p>Garden rooms offer incredible versatility, making them an excellent choice for enhancing your home with a personalised touch. Thanks to their flexible design and diverse functionality, these spaces can be tailored to meet a broad range of needs and activities.</p>
<p><b>Here are a few popular ways to utilise a garden room:</b></p>

<div class="services-slider row benifits-row">
            <div class="item col-lg-4 col-sm-6">
                <div class="services-blk">
                    <span class="cntr">01</span>
                    <i class="flaticon-office-room"></i>
                    <h3>Garden office</h3>
                    <p>Create a productive and peaceful work environment right in your backyard. A garden office provides a private space to focus on tasks and conduct meetings, free from the distractions of home life.</p>                    
                </div>
            </div>
            <!--  -->
            <div class="item col-lg-4 col-sm-6">
                <div class="services-blk">
                    <span class="cntr">02</span>
                    <i class="flaticon-gym"></i>
                    <h3>Garden gym room</h3>
                    <p>Transform your garden room into a personal fitness sanctuary. Equipped with gym essentials like cardio machines and weights, this space allows you to stay active without the need for a gym membership.</p>                    
                </div>
            </div>
            <!--  -->
            <div class="item col-lg-4 col-sm-6">
                <div class="services-blk">
                    <span class="cntr">03</span>
                    <i class="flaticon-bar"></i>
                    <h3>Garden bar</h3>
                    <p>Entertain friends and family in style with a garden bar. This cosy hangout spot can be customised with a wet bar, comfortable seating, and ambient lighting, making it the perfect venue for gatherings and celebrations.</p>                    
                </div>
            </div>
            <!--  -->
            <div class="item col-lg-4 col-sm-6">
                <div class="services-blk">
                    <span class="cntr">04</span>
                    <i class="flaticon-studio"></i>
                    <h3>Garden studio</h3>
                    <p>Let your creativity flow in a garden studio. Whether you’re a musician, painter, or writer, having a dedicated space for your artistic endeavours can inspire new levels of creativity and innovation.</p>                    
                </div>
            </div>
            <!--  -->
            <div class="item col-lg-4 col-sm-6">
                <div class="services-blk">
                    <span class="cntr">05</span>
                    <i class="flaticon-game-room"></i>
                    <h3>Garden games room</h3>
                    <p>Enjoy endless fun with a garden games room. Equipped with pool tables, video games, or board games, this space is perfect for relaxation and entertainment for both adults and kids.</p>                    
                </div>
            </div>
            <!--  -->
            <div class="item col-lg-4 col-sm-6">
                <div class="services-blk">
                    <span class="cntr">06</span>
                    <i class="flaticon-annexes"></i>
                    <h3>Garden annex</h3>
                    <p>Provide a comfortable and independent living space with a garden annex. Ideal for guests or family members, annexes offer all the amenities of a small home, including sleeping quarters and bathroom facilities.</p>                    
                </div>
            </div>
            <!--  -->
            <div class="item col-lg-6 col-sm-6">
                <div class="services-blk">
                    <span class="cntr">07</span>
                    <i class="flaticon-steam"></i>
                    <h3>Garden sauna/steam room</h3>
                    <p>Indulge in luxury with a garden sauna or steam room. This wellness retreat allows you to relax and unwind in your own garden, promoting health benefits such as stress relief and improved circulation.</p>                    
                </div>
            </div>
            <!--  -->
            <div class="item col-lg-6 col-sm-6">
                <div class="services-blk">
                    <span class="cntr">08</span>
                    <i class="flaticon-saloon"></i>
                    <h3>Garden barber salon</h3>
                    <p>Set up a chic and convenient garden barber salon. Perfect for professionals seeking to operate from home, this space can be designed to offer clientele a unique and personal grooming experience.</p>                    
                </div>
            </div>
            <!--  -->
        </div>
    </div>
</section>
<section class="dream-sec padd-sec">
    <div class="container">
    <p><b class="orange-txt">Ranges by style</b></p>
    <h2>Your dream space awaits</h2>
<p>Ready to transform your outdoor area into a personalised sanctuary that meets all your lifestyle needs?</p>
<p>Contact us today to arrange your free design consultation and take the first step toward building your dream garden room. Our experts are eager to turn your vision into reality, ensuring every detail perfectly aligns with your desires.</p>
<p>Get in touch now and let us help you create a space that truly reflects your personality and enhances your home.</p>

<div class="btn-blk">
            <?php echo $contact ?>
            <?php echo $call ?>
        </div>
    </div>
</section>

<?php include 'includes/footer.php';?>
