<?php
$pageTitle = ""; //Please add page title here
$metaDesc = ""; //Please add meta description here
$metaKey = ""; //Please add meta keywords here
include 'includes/header.php';?>
<section id="main-banner" class="inner-banner">
    <img src="<?php echo BASE_URL;?>images/bar/banner.jpg" alt="banner img" class="img-fluid"/>
    <h1>Garden Office
    </h1>
</section>
<section class="inner-sec padd-sec">
    <div class="container">
    <p>Imagine stepping out of your home and into your personalised workspace set amidst the tranquillity of your garden. A garden office provides a unique balance of work and relaxation, offering an environment tailored to enhance productivity while surrounded by nature's beauty.</p>
<p>With increasing numbers of professionals working from home, a garden building could be the perfect solution for achieving a productive yet peaceful work-life balance.</p>

    </div>
</section>
<section class="half-sec row no-gutters">
    <div class="col-lg-6 bg-img" style="background-image:url(images/about-img/about-img.jpg)">
        <img src="images/about-img/about-img.jpg" alt="" class="w-100 d-lg-none">
    </div>
    <div class="col-lg-6">
        <div class="text-blk">
        <h2>Garden office buildings overview</h2>
<p>Elevate Garden Rooms specialises in creating bespoke garden offices that cater to individual needs and tastes. These dedicated workspaces are more than just a room—they're a lifestyle transformation.</p>
<p>A premium garden room from our team offers the comfort of home with the focus of a traditional office, they combine aesthetic appeal with functional design. Every garden office building can be customised with features such as full insulation, double glazing, secure access, and advanced lighting solutions, ensuring comfort and security all year round.</p>


        </div>
    </div>
</section>
<section class="services-sec padd-sec">
    <div class="container">
        <h2>Benefits of a garden offices

        </h2>  
        <div class="services-slider row benifits-row">
            <div class="item col-md-5">
                <div class="services-blk">
                    <span class="cntr">01</span>
                    <i class="flaticon-office-room"></i>
                    <h3>Increased productivity: </h3>
                    <p>A dedicated workspace away from household distractions enables better concentration, leading to enhanced productivity and efficiency in daily tasks.</p>

                </div>
            </div>
            <!--  -->
            <div class="item col-md-7">
                <div class="services-blk">
                    <span class="cntr">02</span>
                    <i class="flaticon-gym"></i>
                    <h3>Cost-effective: </h3>
                    <p>Avoid the expenses associated with commuting or renting office space. Adapting your unused garden space into a modern garden office is a one-time investment that can offer ongoing savings and increase property value.</p>

                </div>
            </div>
            <!--  -->
            <div class="item col-lg-4 col-md-6">
                <div class="services-blk">
                    <span class="cntr">03</span>
                    <i class="flaticon-bar"></i>
                    <h3>Work-life balance: </h3>
                    <p>By physically separating work from home, garden offices help establish a boundary, reducing stress and preventing burnout.</p>


                </div>
            </div>
            <!--  -->
            <div class="item col-lg-4 col-md-6">
                <div class="services-blk">
                    <span class="cntr">04</span>
                    <i class="flaticon-studio"></i>
                    <h3>Customizable environment: </h3>
                    <p>Tailor your office to reflect your personal style and workplace needs, from ergonomic furnishings to high-speed internet connectivity.</p>


                </div>
            </div>
            <!--  -->
            <div class="item col-lg-4 col-md-6">
                <div class="services-blk">
                    <span class="cntr">05</span>
                    <i class="flaticon-game-room"></i>
                    <h3>Environmental impact: </h3>
                    <p>Reduce your carbon footprint by working from home and utilising the eco-friendly materials and construction methods employed by Elevate Garden Rooms.</p>

                </div>
            </div>
            <!--  -->
        </div>
    </div>
</section>

<section class="why-sec padd-sec">
    <div class="container">
        <h2>Why choose Elevate Garden Rooms?</h2>
        <div class="row">
            <div class="col-lg-6 col-md-6">
                <div class="text-blk">
                    <i class="flaticon-tailored"></i>
                    <div class="text">
                    <h4>Expert craftsmanship:</h4>
                     <p>With a team of highly qualified professionals, we ensure that all of our wooden garden offices are built to the highest standards, using top-quality materials that have been hand-picked and approved by our team.</p>

                    </div>
                </div>
            </div>
            <!--  -->
            <div class="col-lg-6 col-md-6">
                <div class="text-blk">
                    <i class="flaticon-quality"></i>
                    <div class="text">
                    <h4>Customised design:</h4>
                     <p>We work closely with you to design a garden office that meets your specifications and preferences, blending seamlessly with your garden landscape.</p>


                    </div>
                </div>
            </div>
            <!--  -->
            <div class="col-lg-6 col-md-6">
                <div class="text-blk">
                    <i class="flaticon-installation"></i>
                    <div class="text">
                    <h4>Comprehensive service:</h4>
                     <p>From the initial consultation to the final installation, Elevate Garden Rooms provides a smooth and stress-free experience, with attention to detail at every step.</p>


                    </div>
                </div>
            </div>
            <!--  -->
            <div class="col-lg-6 col-md-6">
                <div class="text-blk">
                    <i class="flaticon-innovative"></i>
                    <div class="text">
                    <h4>Sustainable practices:</h4>
                     <p>Committed to environmentally friendly practices, we use sustainable materials and methods wherever possible.</p>

                    </div>
                </div>
            </div>
            <!--  -->
        </div>
        <div class="btn-blk">
            <?php echo $contact ?>
            <?php echo $call ?>
        </div>
    </div>
</section>
<section class="gal-row row">
    <?php for($i=4; $i>0; $i--) { ?>
        <div class="gallery_product col-md-3 col-6">
            <a data-fancybox="gallery" href="images/home/gal<?php echo $i?>.jpg" data-caption="<?php echo COMPANY;?>">
            <img class="img-fluid" src="images/home/gal<?php echo $i?>.jpg" alt="<?php echo COMPANY;?>"></a>
        </div>
    <?php } ?>
</section>
<section class="process-sec padd-sec">
    <div class="container text-center">
        <h2>Our easy 5-step process</h2>
        <div class="process-slider owl-carousel">
            <div class="item">
                <i class="flaticon-process1"></i>
                <h3>Reach out </h3>
                <p>fill out our form or contact us directly to kick off your garden room project. </p>
                <img src="images/home/process-arw.png" alt="">
            </div>
            <div class="item">
                <i class="flaticon-process2"></i>
                <h3>Schedule your site visit and design consultation </h3>
                <p>we'll come to your home to evaluate the space and chat about your ideas. </p>

                <img src="images/home/process-arw.png" alt="">
            </div>
            <div class="item">
                <i class="flaticon-process3"></i>
                <h3>Finalise your design </h3>
                <p>collaborate with our designers to complete a design that reflects your style and requirements. </p>

                <img src="images/home/process-arw.png" alt="">
            </div>
            <div class="item">
                <i class="flaticon-process4"></i>
                <h3>Receive your complimentary, no-obligation quote </h3>
                <p>Before we start any work, we provide a transparent, itemised quote detailing all associated costs with no hidden fees or surprises. </p>

                <img src="images/home/process-arw.png" alt="">
            </div>
            <div class="item">
                <i class="flaticon-process5"></i>
                <h3>See your dream garden room become a reality </h3>
                <p>Relax and enjoy the journey as our skilled team turns your vision into reality.</p>

                <img src="images/home/process-arw.png" alt="">
            </div>
        </div>
    </div>
</section>
<section class="faq-sec padd-sec">
    <div class="container">
        <h2>Frequently asked questions</h2>
        <div id="accordion">
            <div class="card">
                <div id="heading1" class="card-header btn btn-link" data-toggle="collapse" data-target="#collapse1" aria-expanded="true" aria-controls="collapse1">
                Q: How long does it take to build a garden office? 

                </div>
                <div id="collapse1" class="collapse show" aria-labelledby="heading1" data-parent="#accordion">
                    <div class="card-body">
                    A: The timeline varies depending on the design complexity, but most garden offices can be completed within a few weeks from the beginning of construction.

                    </div>
                </div>
            </div>
            <!--  -->
            <div class="card">
                <div id="heading2" class="card-header btn btn-link" data-toggle="collapse" data-target="#collapse2" aria-expanded="flase" aria-controls="collapse2">
                Q: Can a garden office be used year-round? 

                </div>
                <div id="collapse2" class="collapse" aria-labelledby="heading2" data-parent="#accordion">
                    <div class="card-body">
                    A: Yes, our contemporary garden offices are far more than a garden office shed or log cabin office. We create for you a fully insulated garden office that can include heating and ventilation options to ensure comfort in any season. Coupled with insulative components such as double glazed windows, you can be sure that your dedicated office space will be warm and welcoming no matter the season.

                    </div>
                </div>
            </div>
            <!--  -->
            <div class="card">
                <div id="heading3" class="card-header btn btn-link" data-toggle="collapse" data-target="#collapse3" aria-expanded="flase" aria-controls="collapse3">
                Q: Do I need planning permission for a garden office? 

                </div>
                <div id="collapse3" class="collapse" aria-labelledby="heading3" data-parent="#accordion">
                    <div class="card-body">
                    A: In most cases, garden offices fall under permitted development rights, so planning permission is not required. However, we recommend checking with local authorities to confirm.

                    </div>
                </div>
            </div>
            <!--  -->
            <div class="card">
                <div id="heading4" class="card-header btn btn-link" data-toggle="collapse" data-target="#collapse4" aria-expanded="flase" aria-controls="collapse4">
                Q: What security features are available? 

                </div>
                <div id="collapse4" class="collapse" aria-labelledby="heading4" data-parent="#accordion">
                    <div class="card-body">
                    A: We offer various security options, such as secure locks, motion-sensor lighting, and alarm systems to protect your workspace.


                    </div>
                </div>
            </div>
            <!--  -->
        </div>
    </div>
</section>

<section class="gal-row row">
    <?php for($i=4; $i>0; $i--) { ?>
        <div class="gallery_product col-md-3 col-6">
            <a data-fancybox="gallery" href="images/home/gal<?php echo $i?>.jpg" data-caption="<?php echo COMPANY;?>">
            <img class="img-fluid" src="images/home/gal<?php echo $i?>.jpg" alt="<?php echo COMPANY;?>"></a>
        </div>
    <?php } ?>
</section>
<section class="dream-sec padd-sec">
    <div class="container">
    <h2>Take the first step towards your dream garden room today!</h2>
    <p>Transform your work-from-home experience with a custom-built garden office from Elevate Garden Rooms.</p>
<p>Elevate your productivity and enjoy an inspiring private space designed just for you. Contact us today to schedule your free design consultation and take the first step towards creating your ideal garden office. Our team is ready to assist you in crafting a space that not only meets your professional needs but also enhances your lifestyle.</p>
<p>Let us help you redefine what it means to work from home.</p>

<div class="btn-blk">
            <?php echo $contact ?>
            <?php echo $call ?>
        </div>
    </div>
</section>
<?php include 'includes/footer.php';?>
