<?php
$pageTitle = ""; //Please add page title here
$metaDesc = ""; //Please add meta description here
$metaKey = ""; //Please add meta keywords here
include 'includes/header.php';?>
<section id="main-banner" class="inner-banner">
    <img src="<?php echo BASE_URL;?>images/bar/banner.jpg" alt="banner img" class="img-fluid"/>
    <h1>About</h1>
</section>
<section class="inner-sec padd-sec">
    <div class="container">
        <p>Unleash the potential of your outdoor space by transforming it into an elegant garden bar. Perfect for entertaining guests or enjoying a peaceful evening cocktail, a garden bar adds a touch of luxury and style to your home.</p>
        <p>This versatile space provides an ideal setting for social gatherings, offering the unique charm of an outdoor setting while retaining the comforts of your house.</p>
        <p>As outdoor living becomes increasingly popular, a garden bar stands out as a distinctive addition that enhances your leisure and entertainment experiences.</p>
     
    </div>
</section>
<section class="half-sec row no-gutters">
    <div class="col-lg-6 bg-img" style="background-image:url(images/about-img/about-img.jpg)">
        <img src="images/about-img/about-img.jpg" alt="" class="w-100 d-lg-none">
    </div>
    <div class="col-lg-6">
        <div class="text-blk">
            <h2>Create your very own outdoor bar</h2>
            <p>Elevate Garden Rooms specialises in creating bespoke garden bars that reflect your personal style and entertaining needs. Whether you envision a chic cocktail lounge, a cosy garden pub-inspired space, or a trendy modern bar, we tailor each design to your specifications.</p>
            <p>Our garden bars can include features like custom cabinetry, ambient lighting, refrigeration, and seating options, ensuring a functional and inviting atmosphere for hosting a range of gatherings. With weather-resistant materials and elegant finishes, your garden bar will be a stunning focal point all year round.</p>
        </div>
    </div>
</section>
<section class="services-sec padd-sec">
    <div class="container">
        <h2>Benefits of garden bars</h2>  
        <div class="services-slider row benifits-row">
            <div class="item col-md-4">
                <div class="services-blk">
                    <span class="cntr">01</span>
                    <i class="flaticon-office-room"></i>
                    <h3>Entertaining space</h3>
                    <p> Maximise your ability to host friends and family with a dedicated outdoor entertaining area, perfect for parties, celebrations and even dining.</p>
                </div>
            </div>
            <!--  -->
            <div class="item col-md-8">
                <div class="services-blk">
                    <span class="cntr">02</span>
                    <i class="flaticon-gym"></i>
                    <h3>Personalised design</h3>
                    <p>Start from scratch or customise your bar from our huge range; our team will help you find the perfect match for your aesthetic and functional preferences.</p>
                    <p>Whether you're looking for something relaxed and rustic or sleek and sophisticated, we have the garden building for you.</p>
                </div>
            </div>
            <!--  -->
            <div class="item col-lg-4 col-md-6">
                <div class="services-blk">
                    <span class="cntr">03</span>
                    <i class="flaticon-bar"></i>
                    <h3>Convenience</h3>
                    <p>Enjoy the luxury of having a bar at home, eliminating the need to travel and pay for expensive drinks.</p>
                </div>
            </div>
            <!--  -->
            <div class="item col-lg-4 col-md-6">
                <div class="services-blk">
                    <span class="cntr">04</span>
                    <i class="flaticon-studio"></i>
                    <h3>Increased property value</h3>
                    <p>A garden bar is a unique feature that enhances the appeal of your home to future buyers, increasing market value.</p>
                </div>
            </div>
            <!--  -->
            <div class="item col-lg-4 col-md-6">
                <div class="services-blk">
                    <span class="cntr">05</span>
                    <i class="flaticon-game-room"></i>
                    <h3>Year-Round Enjoyment</h3>
                    <p>Equipped with the right amenities and heating options, your garden bar can be a gathering spot in every season.</p>
                </div>
            </div>
            <!--  -->
        </div>
    </div>
</section>

<section class="why-sec padd-sec">
    <div class="container">
        <h2>Why choose Elevate Garden Rooms?</h2>
        <div class="row">
            <div class="col-lg-6 col-md-6">
                <div class="text-blk">
                    <i class="flaticon-tailored"></i>
                    <div class="text">
                        <h4>Custom Creations</h4>
                        <p>Collaborate with our design team to create a garden bar that aligns with your vision, ensuring a unique and personal outcome.</p>
                    </div>
                </div>
            </div>
            <!--  -->
            <div class="col-lg-6 col-md-6">
                <div class="text-blk">
                    <i class="flaticon-quality"></i>
                    <div class="text">
                        <h4>Premium Construction</h4>
                        <p>Using quality materials and expert craftsmanship, our garden bars are built to withstand the elements while providing durable elegance.
                        </p>
                    </div>
                </div>
            </div>
            <!--  -->
            <div class="col-lg-6 col-md-6">
                <div class="text-blk">
                    <i class="flaticon-installation"></i>
                    <div class="text">
                        <h4>Sustainable Practices</h4>
                        <p> Our commitment to the environment is reflected in our eco-friendly building techniques and material choices.</p>
                    </div>
                </div>
            </div>
            <!--  -->
            <div class="col-lg-6 col-md-6">
                <div class="text-blk">
                    <i class="flaticon-innovative"></i>
                    <div class="text">
                        <h4>Comprehensive Service</h4>
                        <p>From consultation to completion, our team manages every detail to deliver a seamless and enjoyable building experience.</p>
                    </div>
                </div>
            </div>
            <!--  -->
        </div>
        <div class="btn-blk">
            <?php echo $contact ?>
            <?php echo $call ?>
        </div>
    </div>
</section>
<section class="gal-row row">
    <?php for($i=4; $i>0; $i--) { ?>
        <div class="gallery_product col-md-3 col-6">
            <a data-fancybox="gallery" href="images/home/gal<?php echo $i?>.jpg" data-caption="<?php echo COMPANY;?>">
            <img class="img-fluid" src="images/home/gal<?php echo $i?>.jpg" alt="<?php echo COMPANY;?>"></a>
        </div>
    <?php } ?>
</section>
<section class="process-sec padd-sec">
    <div class="container text-center">
        <h2>Our simple 5-step process</h2>
        <div class="process-slider owl-carousel">
            <div class="item">
                <i class="flaticon-process1"></i>
                <h3>Reach out</h3>
                <p>Complete our form or contact us directly to kick off your garden room project. 
                </p>
                <img src="images/home/process-arw.png" alt="">
            </div>
            <div class="item">
                <i class="flaticon-process2"></i>
                <h3>Schedule your site visit and design consultation</h3>
                <p>We'll come to your home to evaluate the space and chat about your ideas. 
                </p>
                <img src="images/home/process-arw.png" alt="">
            </div>
            <div class="item">
                <i class="flaticon-process3"></i>
                <h3>Finalise your design</h3>
                <p>Work together with our designers to create a design that matches your style and requirements. </p>
                <img src="images/home/process-arw.png" alt="">
            </div>
            <div class="item">
                <i class="flaticon-process4"></i>
                <h3>Receive your complimentary, no-obligation quote </h3>
                <p>Before any work starts, we provide a transparent, detailed written quote that outlines all costs, with no hidden fees or surprises. 
                </p>
                <img src="images/home/process-arw.png" alt="">
            </div>
            <div class="item">
                <i class="flaticon-process5"></i>
                <h3>Enjoy the transformation of your dream garden room</h3>
                <p>Relax and watch as our skilled team brings your vision to life.
                </p>
                <img src="images/home/process-arw.png" alt="">
            </div>
        </div>
    </div>
</section>
<section class="faq-sec padd-sec">
    <div class="container">
        <h2>Frequently asked questions</h2>
        <div id="accordion">
            <div class="card">
                <div id="heading1" class="card-header btn btn-link" data-toggle="collapse" data-target="#collapse1" aria-expanded="true" aria-controls="collapse1">
                Q: How long does it take to build a garden bar?                   
                </div>
                <div id="collapse1" class="collapse show" aria-labelledby="heading1" data-parent="#accordion">
                    <div class="card-body">
                    <p>A: The length of time it takes to construct your bespoke garden bar can vary depending on factors such as size, specific requirements and more.</p>

<p>In general, you can expect an average garden room to be fully built and ready for use within a few weeks.</p>
<p>During your design consultation, our team will give you a personal time scale and we keep you updated throughout every step of the process so you know exactly what is happening and when.</p>

                    </div>
                </div>
            </div>
            <!--  -->
            <div class="card">
                <div id="heading2" class="card-header btn btn-link" data-toggle="collapse" data-target="#collapse2" aria-expanded="flase" aria-controls="collapse2">
                Q: Can the garden bar include electricity and plumbing? 
                 
                </div>
                <div id="collapse2" class="collapse" aria-labelledby="heading2" data-parent="#accordion">
                    <div class="card-body">
                       <p>A: Absolutely! We don't create pub sheds, but instead fully-fledged home bars that can incorporate electrical outlets and plumbing fixtures to accommodate appliances and sinks as needed.</p>
                    </div>
                </div>
            </div>
            <!--  -->
            <div class="card">
                <div id="heading3" class="card-header btn btn-link" data-toggle="collapse" data-target="#collapse3" aria-expanded="flase" aria-controls="collapse3">
                Q: Do I need planning permission for a garden bar? 
               
                </div>
                <div id="collapse3" class="collapse" aria-labelledby="heading3" data-parent="#accordion">
                    <div class="card-body">
                        <p>A: Typically, garden bars fall under permitted development rights. We recommend checking with local authorities to confirm specific requirements.
                        </p>
                    </div>
                </div>
            </div>
            <!--  -->
            <div class="card">
                <div id="heading4" class="card-header btn btn-link" data-toggle="collapse" data-target="#collapse4" aria-expanded="flase" aria-controls="collapse4">
                Q: Can garden bars be furnished to look like real pubs?
                 
                </div>
                <div id="collapse4" class="collapse" aria-labelledby="heading4" data-parent="#accordion">
                    <div class="card-body">
                       <p>A: They certainly can! With the assistance of our highly-creative design team, you can recreate all your favourite aspects from your local, including a pool table, dart board and anything else needed for you to entertain guests and have fun being your very own pub landlord.
                       </p>
                    </div>
                </div>
            </div>
            <!--  -->
            <div class="card">
                <div id="heading5" class="card-header btn btn-link" data-toggle="collapse" data-target="#collapse5" aria-expanded="flase" aria-controls="collapse5">
                Q: What materials are used in constructing garden bars? 
        
                </div>
                <div id="collapse5" class="collapse" aria-labelledby="heading5" data-parent="#accordion">
                    <div class="card-body">
                        <p>A: Our garden bars are crafted from weather-resistant and durable materials, ensuring longevity and low maintenance. To find out more, take a look at our technical and ranges pages.
                        </p>
                    </div>
                </div>
            </div>
            <!--  -->
        </div>
    </div>
</section>

<section class="gal-row row">
    <?php for($i=4; $i>0; $i--) { ?>
        <div class="gallery_product col-md-3 col-6">
            <a data-fancybox="gallery" href="images/home/gal<?php echo $i?>.jpg" data-caption="<?php echo COMPANY;?>">
            <img class="img-fluid" src="images/home/gal<?php echo $i?>.jpg" alt="<?php echo COMPANY;?>"></a>
        </div>
    <?php } ?>
</section>
<section class="dream-sec padd-sec">
    <div class="container">
        <h2>Unwind and entertain with your very own garden bar</h2>
        <p>Revolutionise your outdoor living with a custom-built garden bar by Elevate Garden Rooms.</p>
<p>Whether you're crafting the perfect space for hosting or simply adding a touch of elegance to your home, our team is ready to bring your vision to life.</p>
<p>Contact us today for a complimentary design consultation and begin the journey towards creating your exceptional garden bar.</p>
<div class="btn-blk">
            <?php echo $contact ?>
            <?php echo $call ?>
        </div>
    </div>
</section>
<?php include 'includes/footer.php';?>
