<?php
$pageTitle = ""; //Please add page title here
$metaDesc = ""; //Please add meta description here
$metaKey = ""; //Please add meta keywords here
include 'includes/header.php';?>
<section id="main-banner" class="inner-banner">
    <img src="<?php echo BASE_URL;?>images/bar/banner.jpg" alt="banner img" class="img-fluid"/>
    <h1>Garden annexes</h1>
</section>
<section class="inner-sec padd-sec">
    <div class="container">
        <h2>Introduction</h2>
        <p>Expand the versatility and functionality of your outdoor area with a bespoke garden annexe. Ideal for those in need of an auxiliary space for guests, home offices, or personal retreats, a garden annexe (sometimes known as a granny annexe) offers a seamless extension of your living quarters.</p>
<p>Whether you're providing a cosy sanctuary for visiting family or establishing a remote workspace, a garden annexe is a practical addition that complements modern living needs. With increasing demand for multipurpose spaces at home, a garden annexe is a valuable asset that enhances both utility and comfort.</p>

    </div>
</section>
<section class="half-sec row no-gutters">
    <div class="col-lg-6 bg-img" style="background-image:url(images/about-img/about-img.jpg)">
        <img src="images/about-img/about-img.jpg" alt="" class="w-100 d-lg-none">
    </div>
    <div class="col-lg-6">
        <div class="text-blk">
        <h2>Garden annexe overview</h2>
<p>At Elevate Garden Rooms, we excel in crafting tailored garden annexes that meet your specific requirements. Whether you envision a serene guesthouse, a professional home office, or a tranquil studio space, each annexe is designed to reflect your personal tastes and needs.</p>
<p>Our garden annexes can include features like thermal insulation, comprehensive plumbing, and elegant interior finishes, creating a comfortable and inviting milieu for year-round use. With strong construction and innovative designs, your garden annexe will be a harmonious extension of your home.</p>

        </div>
    </div>
</section>
<section class="services-sec padd-sec">
    <div class="container">
        <h2>Benefits of a garden steam room or sauna</h2>  
        <div class="services-slider row benifits-row">
            <div class="item col-md-8">
                <div class="services-blk">
                    <span class="cntr">01</span>
                    <i class="flaticon-office-room"></i>
                    <h3>Additional living space: </h3>
                    <p>Increase your property's capacity by providing an extra room for guests, family (that's where the name bedroom granny annexe comes from), or personal use.</p>
                </div>
            </div>
            <!--  -->
            <div class="item col-md-4">
                <div class="services-blk">
                    <span class="cntr">02</span>
                    <i class="flaticon-gym"></i>
                    <h3>Personalization: </h3>
                    <p>Customise your annexe to suit diverse functions, whether as a private retreat, a creative studio, or a business office.</p>

                </div>
            </div>
            <!--  -->
            <div class="item col-lg-4 col-md-6">
                <div class="services-blk">
                    <span class="cntr">03</span>
                    <i class="flaticon-bar"></i>
                    <h3>Increased Property Value: </h3>
                    <p>Enhance the allure of your home with a unique feature that attracts potential buyers.</p>

                </div>
            </div>
            <!--  -->
            <div class="item col-lg-4 col-md-6">
                <div class="services-blk">
                    <span class="cntr">04</span>
                    <i class="flaticon-studio"></i>
                    <h3>Standalone Convenience: </h3>
                    <p>Enjoy an independent space with all the amenities required for comfortable living.</p>

                </div>
            </div>
            <!--  -->
            <div class="item col-lg-4 col-md-6">
                <div class="services-blk">
                    <span class="cntr">05</span>
                    <i class="flaticon-game-room"></i>
                    <h3>Adaptable Design: </h3>
                    <p>Easily modify the annexe to accommodate changing needs over time.</p>

                </div>
            </div>
            <!--  -->
        </div>
    </div>
</section>

<section class="why-sec padd-sec">
    <div class="container">
        <h2>Why choose Elevate Garden Rooms?</h2>
        <div class="row">
            <div class="col-lg-6 col-md-6">
                <div class="text-blk">
                    <i class="flaticon-tailored"></i>
                    <div class="text">
                    <h4>Personalized Designs: </h4>
                    <p>Work closely with our professionals to create a garden annexe that aligns with your lifestyle and vision.</p>

                    </div>
                </div>
            </div>
            <!--  -->
            <div class="col-lg-6 col-md-6">
                <div class="text-blk">
                    <i class="flaticon-quality"></i>
                    <div class="text">
                    <h4>Superior Quality: </h4>
                    <p>Crafted from premium materials with meticulous detail to ensure durability and aesthetic appeal.</p>

                    </div>
                </div>
            </div>
            <!--  -->
            <div class="col-lg-6 col-md-6">
                <div class="text-blk">
                    <i class="flaticon-installation"></i>
                    <div class="text">
                    <h4>Sustainable Solutions: </h4>
                    <p>Our eco-conscious approach prioritises sustainable building practices and materials.</p>

                    </div>
                </div>
            </div>
            <!--  -->
            <div class="col-lg-6 col-md-6">
                <div class="text-blk">
                    <i class="flaticon-innovative"></i>
                    <div class="text">
                    <h4>Comprehensive Service: </h4>
                    <p>Our dedicated team will guide you through each phase, from initial concept to project completion, ensuring a smooth experience.</p>

                    </div>
                </div>
            </div>
            <!--  -->
        </div>
        <div class="btn-blk">
            <?php echo $contact ?>
            <?php echo $call ?>
        </div>
    </div>
</section>
<section class="gal-row row">
    <?php for($i=4; $i>0; $i--) { ?>
        <div class="gallery_product col-md-3 col-6">
            <a data-fancybox="gallery" href="images/home/gal<?php echo $i?>.jpg" data-caption="<?php echo COMPANY;?>">
            <img class="img-fluid" src="images/home/gal<?php echo $i?>.jpg" alt="<?php echo COMPANY;?>"></a>
        </div>
    <?php } ?>
</section>
<section class="process-sec padd-sec">
    <div class="container text-center">
        <h2>Our stress-free 5-step process
        </h2>
        <div class="process-slider owl-carousel">
            <div class="item">
                <i class="flaticon-process1"></i>
                <h3>Get in Touch </h3>
                <p>Fill out our contact form or reach out directly to kickstart your garden annexe project.</p>

                <img src="images/home/process-arw.png" alt="">
            </div>
            <div class="item">
                <i class="flaticon-process2"></i>
                <h3>Schedule your site assessment and consultation </h3>
                <p>We'll evaluate your space and discuss your vision during an on-site consultation.</p>
                <img src="images/home/process-arw.png" alt="">
            </div>
            <div class="item">
                <i class="flaticon-process3"></i>
                <h3>Design your concept </h3>
                <p>Collaborate with our designers to create a layout that suits your style and functionality needs.</p>

                <img src="images/home/process-arw.png" alt="">
            </div>
            <div class="item">
                <i class="flaticon-process4"></i>
                <h3>Review your detailed quote </h3>
                <p>Receive a clear, complete quote that covers all aspects of your project without any hidden fees.</p>

                <img src="images/home/process-arw.png" alt="">
            </div>
            <div class="item">
                <i class="flaticon-process5"></i>
                <h3>Experience the transformation of your garden annexe </h3>
                <p>Watch as our skilled team realises your vision, developing a stylish and functional addition to your property.</p>

                <img src="images/home/process-arw.png" alt="">
            </div>
        </div>
    </div>
</section>
<section class="faq-sec padd-sec full-faq">
    <div class="container">
        <h2>Frequently asked questions</h2>
        <div id="accordion">
            <div class="row">
                <div class="col-md-6">
                <div class="card">
                <div id="heading1" class="card-header btn btn-link" data-toggle="collapse" data-target="#collapse1" aria-expanded="true" aria-controls="collapse1">
                Q: Can the garden granny annexe be insulated? 
                </div>
                <div id="collapse1" class="collapse show" aria-labelledby="heading1" data-parent="#accordion">
                    <div class="card-body">
                    A: Yes, we offer insulation options to ensure the annexe remains comfortable throughout the seasons.

                    </div>
                </div>
            </div>
            <!--  -->
            <div class="card">
                <div id="heading2" class="card-header btn btn-link" data-toggle="collapse" data-target="#collapse2" aria-expanded="flase" aria-controls="collapse2">
                Q: Do I need planning permission for a garden annexe? 

                </div>
                <div id="collapse2" class="collapse" aria-labelledby="heading2" data-parent="#accordion">
                    <div class="card-body">
                    <p>A: In many cases, garden annexes fall under permitted development, meaning that planning permission will not be needed. However, it's best to confirm details with your local authority or, alternatively, rely on the expertise and guidance of our professional team.</p>
<p>We'll give you all the information you need about building regulations that apply to your chosen garden room whether it's a one bedroom granny annexe or home office.</p>

                    </div>
                </div>
            </div>
            <!--  -->
            <div class="card">
                <div id="heading3" class="card-header btn btn-link" data-toggle="collapse" data-target="#collapse3" aria-expanded="flase" aria-controls="collapse3">
                Q: What materials are used for building the annexe? 

                </div>
                <div id="collapse3" class="collapse" aria-labelledby="heading3" data-parent="#accordion">
                    <div class="card-body">
                    A: Our annexes are constructed with premium, weather-resistant materials to guarantee longevity and minimal maintenance.

                    </div>
                </div>
            </div>
            <!--  -->
            <div class="card">
                <div id="heading4" class="card-header btn btn-link" data-toggle="collapse" data-target="#collapse4" aria-expanded="flase" aria-controls="collapse4">
                Q: Can garden granny annexes have full plumbing and heating?

                </div>
                <div id="collapse4" class="collapse" aria-labelledby="heading4" data-parent="#accordion">
                    <div class="card-body">
                    A: Absolutely, we regularly integrate plumbing systems and electrical installations to bring our customers fully functional self contained garden annexes. Granny annexe buildings can include everything you would find in the main house, including a shower room and kitchen.

                    </div>
                </div>
            </div>
            <!--  -->
                </div>
                <div class="col-md-6">

                <div class="card">
                <div id="heading5" class="card-header btn btn-link" data-toggle="collapse" data-target="#collapse5" aria-expanded="flase" aria-controls="collapse5">
                Q: What is the installation process for a garden annex?

                </div>
                <div id="collapse5" class="collapse" aria-labelledby="heading5" data-parent="#accordion">
                    <div class="card-body">
                    The installation process typically begins with a site survey to assess your space and needs. After that, we design your annex, ensuring it fits your requirements. Once approved, our team will handle everything from the ground preparation to the final installation, usually completing the job within 8-12 weeks.


                    </div>
                </div>
            </div>
            <!--  -->
                <div class="card">
                <div id="heading6" class="card-header btn btn-link" data-toggle="collapse" data-target="#collapse6" aria-expanded="flase" aria-controls="collapse6">
                Q. How do I maintain my garden annex?

                </div>
                <div id="collapse6" class="collapse" aria-labelledby="heading6" data-parent="#accordion">
                    <div class="card-body">
                    Our garden annexes are designed for low maintenance. Regular checks on the roof, windows, and exterior walls will help keep it in good condition. Depending on the materials used, occasional cleaning or repainting might be necessary. We provide a detailed maintenance guide upon installation.


                    </div>
                </div>
            </div>
            <!--  -->
            <div class="card">
                <div id="heading7" class="card-header btn btn-link" data-toggle="collapse" data-target="#collapse7" aria-expanded="flase" aria-controls="collapse7">
                Q. Are garden annexes energy-efficient?

                </div>
                <div id="collapse7" class="collapse" aria-labelledby="heading7" data-parent="#accordion">
                    <div class="card-body">
                    Yes, our annexes are built with energy efficiency in mind. We use high-quality insulation and offer energy-saving features like double-glazed windows and efficient heating systems to minimise energy consumption and reduce your bills.


                    </div>
                </div>
            </div>
            <!--  -->
            <div class="card">
                <div id="heading8" class="card-header btn btn-link" data-toggle="collapse" data-target="#collapse8" aria-expanded="flase" aria-controls="collapse8">
                Q. Can I use a garden annex year-round?

                </div>
                <div id="collapse8" class="collapse" aria-labelledby="heading8" data-parent="#accordion">
                    <div class="card-body">
                    Certainly! Our garden annexes are designed for year-round use, with robust insulation and effective heating systems to ensure comfort in any season. Whether it's a cosy winter retreat or a summer escape, your annex will provide a comfortable living space throughout the year.


                    </div>
                </div>
            </div>
            <!--  -->
            <div class="card">
                <div id="heading9" class="card-header btn btn-link" data-toggle="collapse" data-target="#collapse9" aria-expanded="flase" aria-controls="collapse9">
                Q. How long will my garden annex last?

                </div>
                <div id="collapse9" class="collapse" aria-labelledby="heading9" data-parent="#accordion">
                    <div class="card-body">
                    With proper maintenance, our garden annexes are designed to last for decades. We use durable, high-quality materials to ensure longevity, and our construction methods adhere to industry standards to provide a sturdy and reliable structure.


                    </div>
                </div>
            </div>
            <!--  -->
                </div>
            </div>
            
        </div>
    </div>
</section>

<section class="gal-row row">
    <?php for($i=4; $i>0; $i--) { ?>
        <div class="gallery_product col-md-3 col-6">
            <a data-fancybox="gallery" href="images/home/gal<?php echo $i?>.jpg" data-caption="<?php echo COMPANY;?>">
            <img class="img-fluid" src="images/home/gal<?php echo $i?>.jpg" alt="<?php echo COMPANY;?>"></a>
        </div>
    <?php } ?>
</section>
<section class="dream-sec padd-sec">
    <div class="container">
    <h2>Get your free quote today!</h2>
<p>Transform your outdoor area into a versatile living space with a custom-built garden annexe from Elevate Garden Rooms.</p>
<p>Whether you need extra accommodation for older family members, a private workspace, or a creative sanctuary, our team is ready to design the perfect annexe to enhance your home and lifestyle. </p>
<p>Contact us today for a free design consultation and take the first step in realising your dream garden annexe.</p>

<div class="btn-blk">
            <?php echo $contact ?>
            <?php echo $call ?>
        </div>
    </div>
</section>
<?php include 'includes/footer.php';?>
