<?php
$pageTitle = ""; //Please add page title here
$metaDesc = ""; //Please add meta description here
$metaKey = ""; //Please add meta keywords here
include 'includes/header.php';?>
<section id="main-banner" class="inner-banner">
    <img src="<?php echo BASE_URL;?>images/range-img/banner.jpg" alt="banner img" class="img-fluid"/>
    <h1>Ranges</h1>
</section>
<section class="inner-content padd-sec">
    <div class="container">
    <h2>Explore our diverse garden room ranges</h2>
        <p>At Elevate Garden Rooms, we appreciate that every garden and homeowner is unique. That's why we offer a vast range of garden room options tailored to fit any style or space requirement you may have. Whether you are looking for a compact retreat to maximise a small garden area or an expansive design to fill a larger plot, we have a solution to meet your needs.</p>
        <p>Our versatile range ensures that no matter the vision you have for your outdoor area, we can craft a garden room that harmonises seamlessly with your setting, catering to specific aesthetic desires and space constraints.</p>
        <hr class="space-hr"/>
        <h2>Ranges by size</h2>
        <p>What included our garden rooms as standard.</p>
        <ul class="range-ul">
            <li>Ground screws insulation for base</li>
            <li>Full electrics and electrical hook up to the house </li>
            <li>Laminate flooring pack £20 m2 supply and fit </li>
            <li>Door and window packages </li>
            <li>Fully insulated & Plastered finish </li>
            <li>1.2mm rubber roof with 10 year guarantee </li>
        </ul>
        <div class="services-slider owl-carousel ranges-carousel">
            <div class="item">
                <img src="images/home/25x25-gardenroom-img.jpg" alt="" class="img-fluid">
                <div class="text-blk">
                    <h5>2.5x2.5 Garden room</h5>
                    <p>Starting from £14,300+VAT</p>                            
                </div>
            </div>
            <div class="item">
                <img src="images/home/3x3-gardenroom-img.jpg" alt="" class="img-fluid">
                <div class="text-blk">
                    <h5>3x3 Garden room</h5>
                    <p>Starting from £14,300+VAT</p>                            
                </div>
            </div>
            <div class="item">
                <img src="images/home/4x3-gardenroom-img.jpg" alt="" class="img-fluid">
                <div class="text-blk">
                    <h5>4x3 Garden room</h5>
                    <p>Starting from £14,300+VAT</p>                            
                </div>
            </div>
            <div class="item">
                <img src="images/home/3x3-gardenroom-img.jpg" alt="" class="img-fluid">
                <div class="text-blk">
                    <h5>5x3 Garden room</h5>
                    <p>Starting from £14,300+VAT</p>                            
                </div>
            </div>
            <div class="item">
                <img src="images/home/6x3-gardenroom-img.jpg" alt="" class="img-fluid">
                <div class="text-blk">
                    <h5>6x3 Garden room</h5>
                    <p>Starting from £14,300+VAT</p>                            
                </div>
            </div>
            <div class="item">
                <img src="images/home/7x3-gardenroom-img.jpg" alt="" class="img-fluid">
                <div class="text-blk">
                    <h5>7x3 Garden room</h5>
                    <p>Starting from £14,300+VAT</p>                            
                </div>
            </div>
             <div class="item">
                <img src="images/home/8x3-gardenroom-img.jpg" alt="" class="img-fluid">
                <div class="text-blk">
                    <h5>8x3 Garden room</h5>
                    <p>Starting from £14,300+VAT</p>
                </div>
            </div>
        </div>
        <hr class="space-hr"/>
        <h2>Ranges by style</h2>
        <div class="range-blk" id="range1">
            <div class="left-txt">
                <h3>Fully Bespoke Garden Rooms - Design & build service</h3>
                <div class="row">
                    <div class="col-lg-4 col-md-6">
                        <h5>Exterior options</h5>
                        <ul class="simple-ul">
                            <li>Dual finish - Example:  render & cedar </li>
                            <li>Decking </li>
                            <li>Lighting systems </li>
                            <li>Green roofs </li>
                            <li>Skylights </li>
                            <li>Corner glass units </li>
                        </ul>
                    </div>
                    <div class="col-lg-8 col-md-6">                        
                        <h5>Interior options</h5>
                        <ul class="simple-ul d-flex">
                            <li>Bespoke bars </li>
                            <li>Media walls </li>
                            <li>Recessed ceilings</li>
                            <li>Bathrooms </li>
                            <li>Kitchens </li>
                            <li>Underfloor heating </li>
                            <li>Air con units </li>
                            <li>Flooring upgrades</li>
                            <li>Herringbone and tiled </li>
                            <li>Sounds systems </li>
                            <li>Wall pannelling </li>
                        </ul>
                    </div>
                </div>
            </div>    
            <div class="right-img">
                <div class="style-slider">
                    <div class="item"><img src="images/bespoke-garden.jpg" alt=""></div>
                </div>
            </div>
        </div>
        <!--  -->
        
        <div class="row">
            <div class="col-xl-6">                
                <!--  -->
                <div class="range-blk rangeCarousel" id="range2">   
                <div id="range2Carousel" class="carousel slide style-carousel" data-ride="carousel">
                    <div class="left-txt">
                        <h3>Elevate Classic Collection</h3>
                        <p>Choose from 3 charming styles:</p>
                        <ol class="carousel-indicators">
                            <li data-target="#range2Carousel" data-slide-to="0">Elevate classic collection 01:<br/>Full composite smooth grain finish.
                            </li>
                            <li data-target="#range2Carousel" data-slide-to="1">Elevate classic collection 02:<br/>Full composite wood grain effect.
                            </li>
                            <li data-target="#range2Carousel" data-slide-to="2">Elevate classic collection 03:<br/>Full composite slated composite.
                            </li>
                        </ol>
                        
                    </div>    
                    <div class="right-img">
                        <div class="carousel-inner">
                            <div class="carousel-item active">
                            <img src="<?php echo BASE_URL;?>images/Classic-Collection.jpg" alt="banner img" class="img-fluid"/>
                            </div>
                            <!-- <div class="carousel-item">
                            <img src="<?php //echo BASE_URL;?>images/Classic-Collection.jpg" alt="banner img" class="img-fluid"/>
                            </div>
                            <div class="carousel-item">
                            <img src="<?php //echo BASE_URL;?>images/Classic-Collection.jpg" alt="banner img" class="img-fluid"/>
                            </div> -->
                        </div>
                        <!-- <div class="carousel-arrow">
                            <a class="carousel-control-prev" href="#range2Carousel" role="button" data-slide="prev">
                            <img src='images/right-arrow.png'>
                            </a>
                            <a class="carousel-control-next" href="#range2Carousel" role="button" data-slide="next">
                            <img src='images/right-arrow.png'>
                            </a>
                        </div> -->
                    </div>
                </div>
                </div>
                <!--  -->
            </div>
            <div class="col-xl-6">                
                <!--  -->
                <div class="range-blk rangeCarousel" id="range3">   
                    
                <div id="range3Carousel" class="carousel slide style-carousel" data-ride="carousel">
                    <div class="left-txt">
                        <h3>Elevate Cedar Retreats 
                        Collection</h3>
                        <p>Cedar retreats come in 2 options:</p>
                        <ol class="carousel-indicators">
                            <li data-target="#range3Carousel" data-slide-to="0">Elevate Cedar Retreats 01<br/>Full cedar
                            </li>
                            <li data-target="#range3Carousel" data-slide-to="1">Elevate Cedar Retreats 02<br/>Cedar front with composite back and sides
                            </li>
                        </ol>
                    </div>    
                    <div class="right-img">
                            <div class="carousel-inner">
                                <div class="carousel-item active">
                                    <img src="<?php echo BASE_URL;?>images/Cedar-Retreats.jpg" alt="banner img" class="img-fluid"/>
                                </div>
                                <!-- <div class="carousel-item">
                                    <img src="<?php //echo BASE_URL;?>images/Cedar-Retreats.jpg" alt="banner img" class="img-fluid"/>
                                </div>
                                <div class="carousel-item">
                                    <img src="<?php //echo BASE_URL;?>images/Cedar-Retreats.jpg" alt="banner img" class="img-fluid"/>
                                </div> -->
                            </div>
                        
                            <!-- <div class="carousel-arrow">
                                <a class="carousel-control-prev" href="#range3Carousel" role="button" data-slide="prev">
                                    <img src='images/right-arrow.png'>
                                </a>
                                <a class="carousel-control-next" href="#range3Carousel" role="button" data-slide="next">
                                    <img src='images/right-arrow.png'>
                                </a>  
                            </div>                           -->
                        </div>
                    </div>
                </div>
                <!--  -->
            </div>            
        </div>   
        <div class="row">
            <div class="col-xl-6">                
                <!--  -->
                <div class="range-blk rangeCarousel" id="range4">   
                    
                <div id="range4Carousel" class="carousel slide style-carousel" data-ride="carousel">    
                    <div class="right-img">
                            <div class="carousel-inner">
                                <div class="carousel-item active">
                                    <img src="<?php echo BASE_URL;?>images/Garden-Getaway.jpg" alt="banner img" class="img-fluid"/>
                                </div>
                                <!-- <div class="carousel-item">
                                    <img src="<?php //echo BASE_URL;?>images/Garden-Getaway.jpg" alt="banner img" class="img-fluid"/>
                                </div>
                                <div class="carousel-item">
                                    <img src="<?php //echo BASE_URL;?>images/Garden-Getaway.jpg" alt="banner img" class="img-fluid"/>
                                </div> -->
                            </div>
                        
                            <!-- <div class="carousel-arrow">
                                <a class="carousel-control-prev" href="#range4Carousel" role="button" data-slide="prev">
                                    <img src='images/right-arrow.png'>
                                </a>
                                <a class="carousel-control-next" href="#range4Carousel" role="button" data-slide="next">
                                    <img src='images/right-arrow.png'>
                                </a>  
                            </div>                           -->
                        </div>
                    <div class="left-txt">
                        <h3>Elevate Garden Getaway (wallet friendly)</h3>
                        <p>Enhance your home for less with our 2 Garden Getaway offerings:</p>
                        <ol class="carousel-indicators">
                            <li data-target="#range4Carousel" data-slide-to="0">Elevate budget friendly room 01<br/>Cedar with metal sheeting</li>
                            <li data-target="#range4Carousel" data-slide-to="1">Elevate budget friendly room 02<br/>Composite with metal sheeting</li>
                        </ol>
                    </div>
                </div>
                </div>
                <!--  -->
            </div>
            <div class="col-xl-6">                
                <!--  -->
                <div class="range-blk rangeCarousel" id="range5">   
                    
                <div id="range5Carousel" class="carousel slide style-carousel" data-ride="carousel">   
                    <div class="right-img">
                            <div class="carousel-inner">
                                <div class="carousel-item active">
                                    <img src="<?php echo BASE_URL;?>images/Canopy-Hideaways.jpg" alt="banner img" class="img-fluid"/>
                                </div>
                                <!-- <div class="carousel-item">
                                    <img src="<?php //echo BASE_URL;?>images/Canopy-Hideaways.jpg" alt="banner img" class="img-fluid"/>
                                </div>
                                <div class="carousel-item">
                                    <img src="<?php //echo BASE_URL;?>images/Canopy-Hideaways.jpg" alt="banner img" class="img-fluid"/>
                                </div> -->
                            </div>
                        
                            <!-- <div class="carousel-arrow">
                                <a class="carousel-control-prev" href="#range5Carousel" role="button" data-slide="prev">
                                    <img src='images/right-arrow.png'>
                                </a>
                                <a class="carousel-control-next" href="#range5Carousel" role="button" data-slide="next">
                                    <img src='images/right-arrow.png'>
                                </a>  
                            </div>                           -->
                        </div>
                    <div class="left-txt">
                        <h3>Elevate Canopy Hideaways (add-on with other ranges)</h3>
                        <!-- <p>3 choices to choose from:</p> -->
                        <ol class="carousel-indicators">
                            <li data-target="#range5Carousel" data-slide-to="0">Elevate canopy hideaway 01<br/>back and side wall</li>
                            <li data-target="#range5Carousel" data-slide-to="1">Elevate canopy hideaway 02<br/>back wall & post</li>
                            <li data-target="#range5Carousel" data-slide-to="2">Elevate canopy hideaway 03<br/>double post</li>
                        </ol>
                    </div>
                    </div>
                </div>
                <!--  -->
            </div>            
        </div>   
        <!--  -->
       
    </div>
</section>


<section class="services-sec padd-sec">
    <div class="container">
        <h2 class="text-left">We make it, you make it yours</h2>  
        <p>Garden rooms offer incredible versatility, making them an excellent choice for enhancing your home with a personalised touch. Thanks to their flexible design and diverse functionality, these spaces can be tailored to meet a broad range of needs and activities.</p>
<p><b>Here are a few popular ways to utilise a garden room:</b></p>

<div class="services-slider row benifits-row">
            <div class="item col-lg-4 col-sm-6">
                <div class="services-blk">
                    <span class="cntr">01</span>
                    <i class="flaticon-office-room"></i>
                    <h3>Garden office</h3>
                    <p>Create a productive and peaceful work environment right in your backyard. A garden office provides a private space to focus on tasks and conduct meetings, free from the distractions of home life.</p>                    
                </div>
            </div>
            <!--  -->
            <div class="item col-lg-4 col-sm-6">
                <div class="services-blk">
                    <span class="cntr">02</span>
                    <i class="flaticon-gym"></i>
                    <h3>Garden gym room</h3>
                    <p>Transform your garden room into a personal fitness sanctuary. Equipped with gym essentials like cardio machines and weights, this space allows you to stay active without the need for a gym membership.</p>                    
                </div>
            </div>
            <!--  -->
            <div class="item col-lg-4 col-sm-6">
                <div class="services-blk">
                    <span class="cntr">03</span>
                    <i class="flaticon-bar"></i>
                    <h3>Garden bar</h3>
                    <p>Entertain friends and family in style with a garden bar. This cosy hangout spot can be customised with a wet bar, comfortable seating, and ambient lighting, making it the perfect venue for gatherings and celebrations.</p>                    
                </div>
            </div>
            <!--  -->
            <div class="item col-lg-4 col-sm-6">
                <div class="services-blk">
                    <span class="cntr">04</span>
                    <i class="flaticon-studio"></i>
                    <h3>Garden studio</h3>
                    <p>Let your creativity flow in a garden studio. Whether you’re a musician, painter, or writer, having a dedicated space for your artistic endeavours can inspire new levels of creativity and innovation.</p>                    
                </div>
            </div>
            <!--  -->
            <div class="item col-lg-4 col-sm-6">
                <div class="services-blk">
                    <span class="cntr">05</span>
                    <i class="flaticon-game-room"></i>
                    <h3>Garden games room</h3>
                    <p>Enjoy endless fun with a garden games room. Equipped with pool tables, video games, or board games, this space is perfect for relaxation and entertainment for both adults and kids.</p>                    
                </div>
            </div>
            <!--  -->
            <div class="item col-lg-4 col-sm-6">
                <div class="services-blk">
                    <span class="cntr">06</span>
                    <i class="flaticon-annexes"></i>
                    <h3>Garden annex</h3>
                    <p>Provide a comfortable and independent living space with a garden annex. Ideal for guests or family members, annexes offer all the amenities of a small home, including sleeping quarters and bathroom facilities.</p>                    
                </div>
            </div>
            <!--  -->
            <div class="item col-lg-6 col-sm-6">
                <div class="services-blk">
                    <span class="cntr">07</span>
                    <i class="flaticon-steam"></i>
                    <h3>Garden sauna/steam room</h3>
                    <p>Indulge in luxury with a garden sauna or steam room. This wellness retreat allows you to relax and unwind in your own garden, promoting health benefits such as stress relief and improved circulation.</p>                    
                </div>
            </div>
            <!--  -->
            <div class="item col-lg-6 col-sm-6">
                <div class="services-blk">
                    <span class="cntr">08</span>
                    <i class="flaticon-saloon"></i>
                    <h3>Garden barber salon</h3>
                    <p>Set up a chic and convenient garden barber salon. Perfect for professionals seeking to operate from home, this space can be designed to offer clientele a unique and personal grooming experience.</p>                    
                </div>
            </div>
            <!--  -->
        </div>
    </div>
</section>
<section class="dream-sec padd-sec">
    <div class="container">
    <p><b class="orange-txt">Ranges by style</b></p>
    <h2>Your dream space awaits</h2>
<p>Ready to transform your outdoor area into a personalised sanctuary that meets all your lifestyle needs?</p>
<p>Contact us today to arrange your free design consultation and take the first step toward building your dream garden room. Our experts are eager to turn your vision into reality, ensuring every detail perfectly aligns with your desires.</p>
<p>Get in touch now and let us help you create a space that truly reflects your personality and enhances your home.</p>

<div class="btn-blk">
            <?php echo $contact ?>
            <?php echo $call ?>
        </div>
    </div>
</section>

<?php include 'includes/footer.php';?>
