<?php
$pageTitle = ""; //Please add page title here
$metaDesc = ""; //Please add meta description here
$metaKey = ""; //Please add meta keywords here
include 'includes/header.php';?>
<section id="main-banner" class="inner-banner">
    <img src="<?php echo BASE_URL;?>images/studio/banner.jpg" alt="banner img" class="img-fluid"/>
    <h1>Garden studio
    </h1>
</section>
<section class="inner-sec padd-sec">
    <div class="container">
    <p>Discover the creative potential of your outdoor area by transforming it into a sophisticated garden studio. Ideal for artists, writers, musicians, or anyone seeking a peaceful retreat, a garden space that has been turned into a studio adds a touch of inspiration and functionality to your home.</p>
<p>This serene space offers an escape from the distractions of daily life, providing the perfect environment for pursuing personal or professional passions. As more people embrace flexible work arrangements and creative endeavours, bespoke garden buildings stand out as an invaluable asset that blend the beauty of nature with the comforts of home.</p>

    </div>
</section>
<section class="half-sec row no-gutters">
    <div class="col-lg-6 bg-img" style="background-image:url(images/studio/studio.jpg)">
        <img src="images/studio/studio.jpg" alt="" class="w-100 d-lg-none">
    </div>
    <div class="col-lg-6">
        <div class="text-blk">
        <h2>Garden room studio overview</h2>
<p>Elevate Garden Rooms specialises in creating bespoke garden studio buildings that cater to your specific needs and artistic ambitions. Whether you desire a minimalist writers’ nook, a vibrant art studio, or a cutting-edge home music studio, we tailor each design to suit your personal style and purpose.</p>
<p>Our garden studios can include features such as natural lighting solutions, soundproofing options, ergonomic workstations, and storage solutions, ensuring a productive and inviting atmosphere for any project. With durable materials and thoughtful designs, your garden studio will be a harmonious extension of your home.</p>


        </div>
    </div>
</section>
<section class="services-sec padd-sec">
    <div class="container">
        <h2>Benefits of a garden studio
        </h2>  
        <div class="services-slider row benifits-row">
            <div class="item col-md-7">
                <div class="services-blk">
                    <span class="cntr">01</span>
                    <i class="flaticon-office-room"></i>
                    <h3>Dedicated workspace: </h3>
                    <p>Create a focused environment that enhances productivity away from home distractions. Perfect for creative and professional projects, garden art studios allow you to feel inspired and focused in your own garden.</p>


                </div>
            </div>
            <!--  -->
            <div class="item col-md-5">
                <div class="services-blk">
                    <span class="cntr">02</span>
                    <i class="flaticon-gym"></i>
                    <h3>Personalised design: </h3>
                    <p>Customise your studio to match your aesthetic and functional needs, from minimal and modern to rustic and eclectic.</p>
                </div>
            </div>
            <!--  -->
            <div class="item col-lg-4 col-md-6">
                <div class="services-blk">
                    <span class="cntr">03</span>
                    <i class="flaticon-bar"></i>
                    <h3>Flexible use: </h3>
                    <p>Adapt the space to serve multiple purposes, such as a yoga retreat, video studio, or hobby room based on changing interests and needs.</p>

                </div>
            </div>
            <!--  -->
            <div class="item col-lg-4 col-md-6">
                <div class="services-blk">
                    <span class="cntr">04</span>
                    <i class="flaticon-studio"></i>
                    <h3>Increased property value: </h3>
                    <p>A garden room is a unique feature that adds appeal to your home, attracting potential buyers and increasing its market value.</p>

                </div>
            </div>
            <!--  -->
            <div class="item col-lg-4 col-md-6">
                <div class="services-blk">
                    <span class="cntr">05</span>
                    <i class="flaticon-game-room"></i>
                    <h3>Year-round Use: </h3>
                    <p>With proper insulation and climate control, your studio can be a comfortable retreat throughout the year.</p>

                </div>
            </div>
            <!--  -->
        </div>
    </div>
</section>

<section class="why-sec padd-sec">
    <div class="container">
        <h2>Why choose Elevate Garden Rooms?</h2>
        <div class="row">
            <div class="col-lg-6 col-md-6">
                <div class="text-blk">
                    <i class="flaticon-tailored"></i>
                    <div class="text">
                    <h4>Bespoke designs: </h4>
                    <p>Work closely with our design team to create a garden studio that meets your unique vision and requirements.</p>

                    </div>
                </div>
            </div>
            <!--  -->
            <div class="col-lg-6 col-md-6">
                <div class="text-blk">
                    <i class="flaticon-quality"></i>
                    <div class="text">
                    <h4>High-quality construction: </h4>
                    <p>Our studios are constructed using premium materials and craftsmanship, ensuring durability and style in any weather.</p>


                    </div>
                </div>
            </div>
            <!--  -->
            <div class="col-lg-6 col-md-6">
                <div class="text-blk">
                    <i class="flaticon-installation"></i>
                    <div class="text">
                    <h4>Eco-friendly solutions: </h4>
                    <p>Our commitment to sustainability is reflected in our use of environmentally-friendly building practices and materials.</p>


                    </div>
                </div>
            </div>
            <!--  -->
            <div class="col-lg-6 col-md-6">
                <div class="text-blk">
                    <i class="flaticon-innovative"></i>
                    <div class="text">
                    <h4>Comprehensive support: </h4>
                    <p>From initial consultation to project completion, our attentive team manages all aspects to ensure a smooth and satisfying building experience.</p>

                    </div>
                </div>
            </div>
            <!--  -->
        </div>
        <div class="btn-blk">
            <?php echo $contact ?>
            <?php echo $call ?>
        </div>
    </div>
</section>
<section class="gal-row row">
    <?php for($i=4; $i>0; $i--) { ?>
        <div class="gallery_product col-md-3 col-6">
            <a data-fancybox="gallery" href="images/studio/gal<?php echo $i?>.jpg" data-caption="<?php echo COMPANY;?>">
            <img class="img-fluid" src="images/studio/gal<?php echo $i?>.jpg" alt="<?php echo COMPANY;?>"></a>
        </div>
    <?php } ?>
</section>
<section class="process-sec padd-sec">
    <div class="container text-center">
        <h2>Our simple 5-step process</h2>
        <div class="process-slider owl-carousel">
            <div class="item">
                <i class="flaticon-process1"></i>
                <h3>Initiate contact</h3>
                <p>Complete our form or reach out to us directly to start your garden studio project.</p>
                <img src="images/home/process-arw.png" alt="">
            </div>
            <div class="item">
                <i class="flaticon-process2"></i>
                <h3>Schedule your site visit and design consultation</h3>
                <p>We’ll visit your location to assess the space and discuss your ideas and preferences.</p>

                <img src="images/home/process-arw.png" alt="">
            </div>
            <div class="item">
                <i class="flaticon-process3"></i>
                <h3>Finalise your design</h3>
                <p>Collaborate with our designers to craft a studio design that fits your style and needs.</p>

                <img src="images/home/process-arw.png" alt="">
            </div>
            <div class="item">
                <i class="flaticon-process4"></i>
                <h3>Receive your detailed, no-obligation quote</h3>
                <p>We provide a transparent and comprehensive quote outlining all project costs with no hidden charges.</p>

                <img src="images/home/process-arw.png" alt="">
            </div>
            <div class="item">
                <i class="flaticon-process5"></i>
                <h3>Enjoy the transformation of your ideal garden studio</h3>
                <p>Watch as our expert team brings your vision to life, creating a stunning and functional space.</p>

                <img src="images/home/process-arw.png" alt="">
            </div>
        </div>
    </div>
</section>
<section class="faq-sec padd-sec">
    <div class="container">
        <h2>Frequently asked questions</h2>
        <div id="accordion">
            <div class="card">
                <div id="heading1" class="card-header btn btn-link" data-toggle="collapse" data-target="#collapse1" aria-expanded="true" aria-controls="collapse1">
                Q: Can the building be soundproofed? 
                </div>
                <div id="collapse1" class="collapse show" aria-labelledby="heading1" data-parent="#accordion">
                    <div class="card-body">
                    A: Yes, soundproofing options are available to create a quiet, distraction-free environment.

                    </div>
                </div>
            </div>
            <!--  -->
            <div class="card">
                <div id="heading2" class="card-header btn btn-link" data-toggle="collapse" data-target="#collapse2" aria-expanded="flase" aria-controls="collapse2">
                Q: Is planning permission required for a garden studio? 


                </div>
                <div id="collapse2" class="collapse" aria-labelledby="heading2" data-parent="#accordion">
                    <div class="card-body">
                    A: Most garden rooms are considered permitted developments and, therefore, are not subject to any additional building regulations. However, it’s advisable to verify with local authorities for specific guidelines.

                    </div>
                </div>
            </div>
            <!--  -->
            <div class="card">
                <div id="heading3" class="card-header btn btn-link" data-toggle="collapse" data-target="#collapse3" aria-expanded="flase" aria-controls="collapse3">
                Q: What materials are used in constructing a garden room? 

                </div>
                <div id="collapse3" class="collapse" aria-labelledby="heading3" data-parent="#accordion">
                    <div class="card-body">
                    A: Our studios are built with high-quality, weather-resistant materials to ensure longevity and low maintenance.

                    </div>
                </div>
            </div>
            <!--  -->
            <div class="card">
                <div id="heading4" class="card-header btn btn-link" data-toggle="collapse" data-target="#collapse4" aria-expanded="flase" aria-controls="collapse4">
                Q: Can the garden room be equipped with internet and electrical outlets? 

                </div>
                <div id="collapse4" class="collapse" aria-labelledby="heading4" data-parent="#accordion">
                    <div class="card-body">
                    A: Absolutely, we can install the necessary cabling and outlets to support your connectivity and electrical needs.


                    </div>
                </div>
            </div>
            <!--  -->
            <div class="card">
                <div id="heading4" class="card-header btn btn-link" data-toggle="collapse" data-target="#collapse4" aria-expanded="flase" aria-controls="collapse4">
                Q: Can I use the building all-year-round?

                </div>
                <div id="collapse4" class="collapse" aria-labelledby="heading4" data-parent="#accordion">
                    <div class="card-body">
                    Most definitely. Unlike log cabins, our garden rooms are built to be used as you would any other part of your home. That means all interior walls are insulated and we also include double glazed windows and double doors, to bring you a fully insulated garden room.

                    </div>
                </div>
            </div>
            <!--  -->
        </div>
    </div>
</section>

<section class="dream-sec padd-sec">
    <div class="container">
    <h2>Get started on your perfect garden building today!</h2>
<p>Unlock the potential of your outdoor space with a custom-built garden studio from Elevate Garden Rooms. Whether you're seeking a creative haven or a productive workspace, our team is eager to help you design the perfect studio to enhance your home life.</p>
<p>Contact us today for a free design consultation and take the first step towards creating your dream garden studio.</p>

<div class="btn-blk">
            <?php echo $contact ?>
            <?php echo $call ?>
        </div>
    </div>
</section>
<?php include 'includes/footer.php';?>
