<?php
$pageTitle = ""; //Please add page title here
$metaDesc = ""; //Please add meta description here
$metaKey = ""; //Please add meta keywords here
include 'includes/header.php';?>
<section id="main-banner" class="inner-banner">
    <img src="<?php echo BASE_URL;?>images/sauna/banner.jpg" alt="banner img" class="img-fluid"/>
    <h1>Garden sauna room and steam room</h1>
</section>
<section class="inner-sec padd-sec">
    <div class="container">
        <h2>Introduction</h2>
        <p>Transform your own garden into a personal oasis of relaxation and wellness with a custom-built steam room or sauna. Perfect for unwinding after a long day or for indulging in a therapeutic experience, a garden steam room or sauna provides you with a sanctuary just a few steps from your home.</p>
<p>With modern designs tailored to suit your surroundings, your garden sauna can become a cherished retreat for health and relaxation enthusiasts.</p>

    </div>
</section>
<section class="half-sec row no-gutters">
    <div class="col-lg-6 bg-img" style="background-image:url(images/sauna/sauna.jpg)">
        <img src="images/sauna/sauna.jpg" alt="" class="w-100 d-lg-none">
    </div>
    <div class="col-lg-6">
        <div class="text-blk">
        <h2>Steam room and sauna overview</h2>
<p>At Elevate Garden Rooms, we specialise in creating bespoke steam rooms and saunas that cater to your desires and needs. Whether you dream of a traditional sauna experience or a modern steam room with advanced features, our designs ensure a seamless integration within your garden space.</p>
<p>With options such as energy-efficient heating, moisture-resistant materials, and aesthetically pleasing finishes, your garden steam room or sauna will become a sophisticated extension of your lifestyle.</p>


        </div>
    </div>
</section>
<section class="services-sec padd-sec">
    <div class="container">
        <h2>Benefits of a garden steam room or sauna</h2>  
        <div class="services-slider row benifits-row">
            <div class="item col-md-8">
                <div class="services-blk">
                    <span class="cntr">01</span>
                    <i class="flaticon-office-room"></i>
                    <h3>Health and wellness: </h3>
                    <p>Regular use of a steam room or sauna supports overall well-being. The heat promotes relaxation and improves circulation in the body.</p>
                </div>
            </div>
            <!--  -->
            <div class="item col-md-4">
                <div class="services-blk">
                    <span class="cntr">02</span>
                    <i class="flaticon-gym"></i>
                    <h3>Personalised sanctuary: </h3>
                    <p>Create a private space for rejuvenation, tailored to your preferences with customizable features.</p>

                </div>
            </div>
            <!--  -->
            <div class="item col-lg-4 col-md-6">
                <div class="services-blk">
                    <span class="cntr">03</span>
                    <i class="flaticon-bar"></i>
                    <h3>Increased property value: </h3>
                    <p>Enhance the appeal and value of your home with a luxurious and unique feature.</p>
                </div>
            </div>
            <!--  -->
            <div class="item col-lg-4 col-md-6">
                <div class="services-blk">
                    <span class="cntr">04</span>
                    <i class="flaticon-studio"></i>
                    <h3>Convenience at home: </h3>
                    <p>Enjoy the benefits of a spa experience without needing to leave the comfort of your home.</p>
                </div>
            </div>
            <!--  -->
            <div class="item col-lg-4 col-md-6">
                <div class="services-blk">
                    <span class="cntr">05</span>
                    <i class="flaticon-game-room"></i>
                    <h3>Year-round use: </h3>
                    <p>Designed for both functionality and aesthetics, your garden sauna or steam room is suitable for every season.</p>
                </div>
            </div>
            <!--  -->
        </div>
    </div>
</section>

<section class="why-sec padd-sec">
    <div class="container">
        <h2>Why choose Elevate Garden Rooms?</h2>
        <div class="row">
            <div class="col-lg-6 col-md-6">
                <div class="text-blk">
                    <i class="flaticon-tailored"></i>
                    <div class="text">
                    <h4>Tailored creations: </h4>
                    <p>Work with our team to design a steam room or sauna that reflects your style and individual needs.</p>
                    </div>
                </div>
            </div>
            <!--  -->
            <div class="col-lg-6 col-md-6">
                <div class="text-blk">
                    <i class="flaticon-quality"></i>
                    <div class="text">
                    <h4>Premium craftsmanship: </h4>
                    <p>Built with top-quality materials to ensure robustness, energy efficiency, and lasting beauty.</p>

                    </div>
                </div>
            </div>
            <!--  -->
            <div class="col-lg-6 col-md-6">
                <div class="text-blk">
                    <i class="flaticon-installation"></i>
                    <div class="text">
                    <h4>Eco-friendly approach: </h4>
                    <p>Committed to using environmentally sustainable practices and materials throughout our projects.</p>

                    </div>
                </div>
            </div>
            <!--  -->
            <div class="col-lg-6 col-md-6">
                <div class="text-blk">
                    <i class="flaticon-innovative"></i>
                    <div class="text">
                    <h4>Dedicated support: </h4>
                    <p>From design to final installation, our team is with you every step of the process to ensure satisfaction.</p>

                    </div>
                </div>
            </div>
            <!--  -->
        </div>
        <div class="btn-blk">
            <?php echo $contact ?>
            <?php echo $call ?>
        </div>
    </div>
</section>
<section class="gal-row row">
    <?php for($i=4; $i>0; $i--) { ?>
        <div class="gallery_product col-md-3 col-6">
            <a data-fancybox="gallery" href="images/sauna/gal<?php echo $i?>.jpg" data-caption="<?php echo COMPANY;?>">
            <img class="img-fluid" src="images/sauna/gal<?php echo $i?>.jpg" alt="<?php echo COMPANY;?>"></a>
        </div>
    <?php } ?>
</section>
<section class="process-sec padd-sec">
    <div class="container text-center">
        <h2>Our stress-free 5-step process
        </h2>
        <div class="process-slider owl-carousel">
            <div class="item">
                <i class="flaticon-process1"></i>
                <h3>Get in touch</h3>
                <p>Start your project by contacting us to express your interest in a garden steam room or sauna.</p>

                <img src="images/home/process-arw.png" alt="">
            </div>
            <div class="item">
                <i class="flaticon-process2"></i>
                <h3>Book your consultation</h3>
                <p>We’ll conduct a site visit to discuss your vision and evaluate the space.</p>

                <img src="images/home/process-arw.png" alt="">
            </div>
            <div class="item">
                <i class="flaticon-process3"></i>
                <h3>Design your concept</h3>
                <p>Collaborate with our team to create a beautiful and practical layout. At this stage we can decide the placement of the actual sauna, steam room and changing room.</p>

                <img src="images/home/process-arw.png" alt="">
            </div>
            <div class="item">
                <i class="flaticon-process4"></i>
                <h3>Review your detailed proposal</h3>
                <p>We provide a comprehensive, transparent proposal outlining your project's specifications.</p>
                <img src="images/home/process-arw.png" alt="">
            </div>
            <div class="item">
                <i class="flaticon-process5"></i>
                <h3>Relax and enjoy your garden retreat</h3>
                <p>Watch as our experts bring your dream steam room or sauna to life in your garden setting.</p>

                <img src="images/home/process-arw.png" alt="">
            </div>
        </div>
    </div>
</section>
<section class="faq-sec padd-sec">
    <div class="container">
        <h2>Frequently asked questions</h2>
        <div id="accordion">
            <div class="card">
                <div id="heading1" class="card-header btn btn-link" data-toggle="collapse" data-target="#collapse1" aria-expanded="true" aria-controls="collapse1">
                Q: Are steam rooms and outdoor sauna cabins energy-efficient? 

                </div>
                <div id="collapse1" class="collapse show" aria-labelledby="heading1" data-parent="#accordion">
                    <div class="card-body">
                    A: Yes, our designs incorporate energy-saving technologies to minimise running costs while maximising enjoyment.
                    </div>
                </div>
            </div>
            <!--  -->
            <div class="card">
                <div id="heading2" class="card-header btn btn-link" data-toggle="collapse" data-target="#collapse2" aria-expanded="flase" aria-controls="collapse2">
                Q: Can I choose specific materials for my sauna or steam room? 
  
                </div>
                <div id="collapse2" class="collapse" aria-labelledby="heading2" data-parent="#accordion">
                    <div class="card-body">
                    A: Absolutely, we offer a range of materials to match your style preferences and ensure durability.

                    </div>
                </div>
            </div>
            <!--  -->
            <div class="card">
                <div id="heading3" class="card-header btn btn-link" data-toggle="collapse" data-target="#collapse3" aria-expanded="flase" aria-controls="collapse3">
                Q: Do I need planning permission for a garden sauna? 

                </div>
                <div id="collapse3" class="collapse" aria-labelledby="heading3" data-parent="#accordion">
                    <div class="card-body">
                    A: Generally, they are considered permitted development, but local regulations may vary. We will offer expert advice and guidance throughout your consultation.

                    </div>
                </div>
            </div>
            <!--  -->
            <div class="card">
                <div id="heading4" class="card-header btn btn-link" data-toggle="collapse" data-target="#collapse4" aria-expanded="flase" aria-controls="collapse4">
                Q: Can you provide both electrical and plumbing installations? 

                </div>
                <div id="collapse4" class="collapse" aria-labelledby="heading4" data-parent="#accordion">
                    <div class="card-body">
                    A: Yes, we can integrate the necessary systems to ensure full functionality of your heater and all other components of the steam room or sauna.

                    </div>
                </div>
            </div>
            <!--  -->
            <div class="card">
                <div id="heading5" class="card-header btn btn-link" data-toggle="collapse" data-target="#collapse5" aria-expanded="flase" aria-controls="collapse5">
                Q: Can you create a garden sauna in a small garden?

                </div>
                <div id="collapse5" class="collapse" aria-labelledby="heading5" data-parent="#accordion">
                    <div class="card-body">
                    <p>A: Yes, we can create a garden sauna to fit even small garden spaces. Our bespoke designs are adaptable to various sizes to suit your specific requirements. For example, compact garden saunas  might be designed with internal dimensions as small as 1200 mm by 1800 mm, allowing for a cosy yet functional space.</p>
<p>Whether you need a space-efficient design or something more expansive, we ensure each project is uniquely tailored to your space and vision.</p>

                    </div>
                </div>
            </div>
            <!--  -->
        </div>
    </div>
</section>

<section class="dream-sec padd-sec">
    <div class="container">
    <h2>Book your free design consultation today!</h2>
<p>Escape to tranquillity with a custom-built garden steam room or sauna from Elevate Garden Rooms. Whether you're seeking a traditional sauna experience or a modern steam room sanctuary, our team is poised to design a relaxing retreat that enhances your well-being and lifestyle.</p>
<p>Contact us today to schedule your free consultation and start the journey toward your personal garden oasis.</p>

<div class="btn-blk">
            <?php echo $contact ?>
            <?php echo $call ?>
        </div>
    </div>
</section>
<?php include 'includes/footer.php';?>
