<?php
$pageTitle = ""; //Please add page title here
$metaDesc = ""; //Please add meta description here
$metaKey = ""; //Please add meta keywords here
include 'includes/header.php';?>
<section id="main-banner" class="inner-banner">
    <img src="<?php echo BASE_URL;?>images/bar/banner.jpg" alt="banner img" class="img-fluid"/>
    <h1>Garden gym rooms</h1>
</section>
<section class="inner-sec padd-sec">
    <div class="container">
    <p>Step into a new realm of fitness by transforming your outdoor space into an inspiring home gym. This innovative solution offers the perfect combination of privacy and accessibility, enabling you to engage in workout routines without the need to leave your home.</p>
<p>A garden gym provides a unique setting that allows you to exercise surrounded by nature, fostering both physical well-being and mental relaxation. As the trend of home fitness continues to grow, a garden gym room offers an ideal pathway to achieving your health and fitness goals.</p>

     
    </div>
</section>
<section class="half-sec row no-gutters">
    <div class="col-lg-6 bg-img" style="background-image:url(images/gym/gym.jpg)">
        <img src="images/gym/gym.jpg" alt="" class="w-100 d-lg-none">
    </div>
    <div class="col-lg-6">
        <div class="text-blk">
        <h2>Garden room gym overview</h2>
<p>Elevate Garden Rooms brings a bespoke touch to your fitness aspirations with our custom-designed garden room buildings. Each space is crafted to suit individual fitness needs, preferences, and aesthetics. Whether you're a yoga enthusiast, a weightlifting aficionado, or simply looking for an outdoor space to carry out a complete exercise routine, our garden gyms are designed to accommodate all types of workout equipment.</p>
<p>With features like robust flooring, ample lighting, and climate control, your outdoor gym will be the optimal environment for exercise at any time of the year.</p>

        </div>
    </div>
</section>
<section class="services-sec padd-sec">
    <div class="container">
        <h2>Benefits of a garden gym room
        </h2>  
        <div class="services-slider row benifits-row">
            <div class="item col-md-7">
                <div class="services-blk">
                    <span class="cntr">01</span>
                    <i class="flaticon-office-room"></i>
                    <h3>Convenience and privacy:</h3> 
                    <p>Avoid crowded public gyms and enjoy the convenience of working out at home. Personalise your gym space to feel comfortable and private.</p>

                </div>
            </div>
            <!--  -->
            <div class="item col-md-5">
                <div class="services-blk">
                    <span class="cntr">02</span>
                    <i class="flaticon-gym"></i>
                    <h3>Free time management:</h3> 
                    <p>Train on your schedule without constraints, giving you more freedom to balance fitness with other responsibilities.</p>

                </div>
            </div>
            <!--  -->
            <div class="item col-lg-4 col-md-6">
                <div class="services-blk">
                    <span class="cntr">03</span>
                    <i class="flaticon-bar"></i>
                    <h3>Healthier lifestyle:</h3> 
                    <p>Encourages a healthier lifestyle by making exercise more accessible and enjoyable, reducing barriers to daily workouts.</p>

                </div>
            </div>
            <!--  -->
            <div class="item col-lg-4 col-md-6">
                <div class="services-blk">
                    <span class="cntr">04</span>
                    <i class="flaticon-studio"></i>
                    <h3>Customizable space:</h3> 
                    <p>Design your gym room to reflect your fitness regime, incorporating everything from resistance training equipment to a meditative yoga area.</p>

                </div>
            </div>
            <!--  -->
            <div class="item col-lg-4 col-md-6">
                <div class="services-blk">
                    <span class="cntr">05</span>
                    <i class="flaticon-game-room"></i>
                    <h3>Property value increase:</h3> 
                    <p>A garden gym room offers a value-added feature to your home, appealing to future buyers who prioritise health and leisure.</p>

                </div>
            </div>
            <!--  -->
        </div>
    </div>
</section>

<section class="why-sec padd-sec">
    <div class="container">
        <h2>Why choose Elevate Garden Rooms?</h2>
        <div class="row">
            <div class="col-lg-6 col-md-6">
                <div class="text-blk">
                    <i class="flaticon-tailored"></i>
                    <div class="text">
                    <h4>Tailored solutions: </h4>
                    <p>We deliver personalised garden gym rooms that cater to your specific fitness needs, ensuring a space that is functional yet aesthetically pleasing.</p>

                    </div>
                </div>
            </div>
            <!--  -->
            <div class="col-lg-6 col-md-6">
                <div class="text-blk">
                    <i class="flaticon-quality"></i>
                    <div class="text">
                    <h4>Quality construction: </h4>
                    <p>Built with precision and high-grade materials, our garden buildings are designed to support rigorous physical activity safely and effectively.</p>
                    </div>
                </div>
            </div>
            <!--  -->
            <div class="col-lg-6 col-md-6">
                <div class="text-blk">
                    <i class="flaticon-installation"></i>
                    <div class="text">
                    <h4>Eco-friendly approach: </h4>
                    <p>Like all Elevate Garden Rooms, our gym rooms utilise sustainable construction methods and materials to reduce environmental impact.</p>

                    </div>
                </div>
            </div>
            <!--  -->
            <div class="col-lg-6 col-md-6">
                <div class="text-blk">
                    <i class="flaticon-innovative"></i>
                    <div class="text">
                    <h4>Holistic service: </h4>
                    <p>Our team guides you through each step from planning and design to construction to provide a stress-free experience.</p>

                    </div>
                </div>
            </div>
            <!--  -->
        </div>
        <div class="btn-blk">
            <?php echo $contact ?>
            <?php echo $call ?>
        </div>
    </div>
</section>
<section class="gal-row row">
    <?php for($i=4; $i>0; $i--) { ?>
        <div class="gallery_product col-md-3 col-6">
            <a data-fancybox="gallery" href="images/gym/<?php echo $i?>.jpg" data-caption="<?php echo COMPANY;?>">
            <img class="img-fluid" src="images/gym/thumb/<?php echo $i?>.jpg" alt="<?php echo COMPANY;?>"></a>
        </div>
    <?php } ?>
</section>
<section class="process-sec padd-sec">
    <div class="container text-center">
        <h2>Our straightforward 5-step process</h2>
        <div class="process-slider owl-carousel">
            <div class="item">
                <i class="flaticon-process1"></i>
                <h3>Reach out</h3>
                <p>complete our form or contact us directly to kick off your garden room project.

                </p>
                <img src="images/home/process-arw.png" alt="">
            </div>
            <div class="item">
                <i class="flaticon-process2"></i>
                <h3>Schedule your site visit and design consultation</h3>
                <p>we'll come to your home to evaluate the space and hear your ideas.

                </p>
                <img src="images/home/process-arw.png" alt="">
            </div>
            <div class="item">
                <i class="flaticon-process3"></i>
                <h3>Finalise your design</h3>
                <p>Collaborate with our designers to discuss garden gym ideas and create a plan that fits your style and requirements.</p>
                <img src="images/home/process-arw.png" alt="">
            </div>
            <div class="item">
                <i class="flaticon-process4"></i>
                <h3>Get your free, no-obligation quote </h3>
                <p>Before we start any work, you'll receive a clear, detailed written quote that outlines all costs, ensuring no hidden fees or surprises.

                </p>
                <img src="images/home/process-arw.png" alt="">
            </div>
            <div class="item">
                <i class="flaticon-process5"></i>
                <h3>Watch your dream garden room take shape</h3>
                <p>Relax and enjoy the journey as our skilled team works to bring your garden room vision to life.

                </p>
                <img src="images/home/process-arw.png" alt="">
            </div>
        </div>
    </div>
</section>
<section class="faq-sec padd-sec">
    <div class="container">
        <h2>Frequently asked questions</h2>
        <div id="accordion">
            <div class="card">
                <div id="heading1" class="card-header btn btn-link" data-toggle="collapse" data-target="#collapse1" aria-expanded="true" aria-controls="collapse1">
                Q: What kind of gym equipment can be fit into a home gym? 
                 
                </div>
                <div id="collapse1" class="collapse show" aria-labelledby="heading1" data-parent="#accordion">
                    <div class="card-body">
                    A: The space can accommodate various equipment like cardio machines, free weights, resistance bands, and mats for yoga or pilates.


                    </div>
                </div>
            </div>
            <!--  -->
            <div class="card">
                <div id="heading2" class="card-header btn btn-link" data-toggle="collapse" data-target="#collapse2" aria-expanded="flase" aria-controls="collapse2">
                Q: Are your garden gyms insulated? 

                </div>
                <div id="collapse2" class="collapse" aria-labelledby="heading2" data-parent="#accordion">
                    <div class="card-body">
                    A: Yes, we will construct a fully insulated garden room using superior insulative material and double glazed windows. This is no log cabin workout space, but a premium fully bespoke personal gym complete with climate control features such as heating, ventilation, and cooling to maintain a comfortable workout environment that allows for year round use.

                    </div>
                </div>
            </div>
            <!--  -->
            <div class="card">
                <div id="heading3" class="card-header btn btn-link" data-toggle="collapse" data-target="#collapse3" aria-expanded="flase" aria-controls="collapse3">
                Q: Do I need planning permission for a garden home gym? 

               
                </div>
                <div id="collapse3" class="collapse" aria-labelledby="heading3" data-parent="#accordion">
                    <div class="card-body">
                    A: Generally, garden rooms are permitted developments and do not require planning permission. We suggest verifying with local authorities to ensure compliance.

                    </div>
                </div>
            </div>
            <!--  -->
            <div class="card">
                <div id="heading4" class="card-header btn btn-link" data-toggle="collapse" data-target="#collapse4" aria-expanded="flase" aria-controls="collapse4">
                Q: Can a garden gym be soundproofed? 

                </div>
                <div id="collapse4" class="collapse" aria-labelledby="heading4" data-parent="#accordion">
                    <div class="card-body">
                    A: Yes, we can incorporate soundproofing solutions to minimise noise impact and enhance your exercise focus.

                    </div>
                </div>
            </div>
            <!--  -->
        </div>
    </div>
</section>

<section class="dream-sec padd-sec">
    <div class="container">
        <h2>Take your fitness routine to the next level with a bespoke garden gym building
        </h2>
        <p>Enhance your fitness journey with a custom-built new garden gym room from Elevate Garden Rooms. Create a personalised workout sanctuary equipped with everything you need to achieve your health goals.</p>
<p>Contact us today for a free consultation and take the first step towards building your ideal exercise space.</p>
<p>Allow our team to assist you in designing a garden room gym that harmonises with your lifestyle and supports your fitness aspirations.</p>

<div class="btn-blk">
            <?php echo $contact ?>
            <?php echo $call ?>
        </div>
    </div>
</section>
<?php include 'includes/footer.php';?>
